<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:mail="org.ametys.plugins.workspaces.project.helper.MailXSLTHelper">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:variable name="multipleSuffix"><xsl:if test="count(/notification/activity/files) > 1">_MULTIPLE</xsl:if></xsl:variable>
    
    <xsl:template name="title">
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_{/notification/eventKey}_TITLE{$multipleSuffix}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
                <i18n:param name="numberOfFiles"><xsl:value-of select="count(activity/files)"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
    <xsl:template name="section-hint">
        <xsl:if test="activity/parentPath != '/documents'">
            <hint root-data="true" parentURL="{resolver:resolve('page', modulePageId, false(), true())}">
                <i18n:translate>
                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_{/notification/eventKey}_SECTION_HINT{$multipleSuffix}" i18n:catalogue="plugin.workspaces"/>
                    <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                    <i18n:param name="project"><xsl:value-of select="project"/></i18n:param>
                    <i18n:param name="numberOfFiles"><xsl:value-of select="count(activity/files)"/></i18n:param>
                    <i18n:param name="parentName"><xsl:value-of select="activity/parentFolder"/></i18n:param>
                    <i18n:param name="parentPath"><xsl:value-of select="activity/parentPath"/></i18n:param>
                </i18n:translate>
            </hint>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="activity">
        <xsl:variable name="activity" select="."/>
        <xsl:for-each select="files|file">
            <item type="resource">
                <title><xsl:value-of select="@name"/></title>
                <xsl:apply-templates select="$activity" mode="author"/>
                <xsl:apply-templates select="$activity" mode="last-modified"/>
                <fileType>
                    <xsl:choose>
                        <xsl:when test="@mimeType != ''"><xsl:value-of select="mail:getFileType(@mimeType)"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="mail:getFileTypeFromId(@id)"/></xsl:otherwise>
                    </xsl:choose>
                </fileType>
                <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            </item>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="activity[type= 'resource.commented']">
        <xsl:variable name="activity" select="."/>
        <xsl:for-each select="files|file">
            <item type="resource">
                <title><xsl:value-of select="@name"/></title>
                <xsl:apply-templates select="$activity" mode="last-contributor"/>
                <xsl:apply-templates select="$activity" mode="last-modified"/>
                <fileType>
                    <xsl:choose>
                        <xsl:when test="@mimeType != ''"><xsl:value-of select="mail:getFileType(@mimeType)"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="mail:getFileTypeFromId(@id)"/></xsl:otherwise>
                    </xsl:choose>
                </fileType>
                <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
                <comments>
                    <comment>
                        <xsl:apply-templates select="$activity" mode="author"/>
                        <xsl:apply-templates select="$activity" mode="datetime"/>
                        <xsl:apply-templates select="$activity" mode="comment-content"/>
                    </comment>
                </comments>
            </item>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="activity[type = 'resource.commented']" mode="last-modified">
        <lastModified><xsl:value-of select="lastModified"/></lastModified>
    </xsl:template>
    
    <xsl:template match="activity" mode="last-modified">
        <lastModified><xsl:value-of select="date"/></lastModified>
    </xsl:template>
    
    <xsl:template match="activity" mode="last-contributor">
        <author>
            <login><xsl:value-of select="lastContributor/@login"/></login>
            <populationId><xsl:value-of select="lastContributor/@populationId"/></populationId>
            <fullname><xsl:value-of select="lastContributor"/></fullname>
        </author>
    </xsl:template>
    
    <xsl:template match="activity" mode="datetime">
        <datetime><xsl:value-of select="date"/></datetime>
    </xsl:template>
    
    <xsl:template match="activity" mode="comment-content">
        <content><xsl:value-of select="commentSummary"/></content>
    </xsl:template>
    
    <xsl:template name="section-button">
        <xsl:variable name="fileId">
            <xsl:call-template name="fileId"/>
        </xsl:variable>
        <button>
            <text>
                <xsl:choose>
                    <xsl:when test="$fileId != '' and /notification/eventKey != 'RESOURCE_DELETED'">
                        <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_RESOURCE_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
                    </xsl:otherwise>
                </xsl:choose>
            </text>
            <href>
                <xsl:call-template name="section-button-href">
                    <xsl:with-param name="fileId" select="$fileId"/>
                </xsl:call-template>
            </href>
            <width>300</width>
        </button>
    </xsl:template>
    
    <xsl:template name="section-button-href">
        <xsl:param name="fileId"/>
        
        <xsl:choose>
            <xsl:when test="modulePageId != ''">
                <xsl:choose>
                    <xsl:when test="$fileId != '' and /notification/eventKey != 'RESOURCE_DELETED'">
                        <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>#file-<xsl:value-of select="$fileId"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="fileId">
        <xsl:choose>
            <xsl:when test="activity/file/@id != ''">
                <xsl:value-of select="activity/file/@id"/>
            </xsl:when>
            <xsl:when test="count(activity/files) = 1">
                <xsl:value-of select="activity/files[1]/@id"/>
            </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>