<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
                              
    <!-- 
    <item type="task">
        <title>foo</title>
        <lastModified>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</lastModified>
        <eventType>TASK_CREATED|...</eventType>
        <author>
            <login/>
            <populationId/>
            <fullname/>
            <firstname/>
            <email/>
            ...
        </author>
        <multiple>true|false</multiple>
        <nbAttachments>int</nbAttachments>
    <item>
     -->
     
    <xsl:template match="item[@type='task']" mode="item-content">
        <table align="left" border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
            <tbody>
                <tr>
                    <td width="32" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
                        <xsl:apply-templates select="." mode="item-icon"/>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">5</xsl:with-param>
                    </xsl:call-template>
                    <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                        <xsl:call-template name="table-vertical-spacer">
                            <xsl:with-param name="height">0</xsl:with-param>
                        </xsl:call-template>
                        <xsl:apply-templates select="." mode="item-title"/>
                        <xsl:apply-templates select="." mode="item-details"/>
                    </td>
                    
                    <!-- Number of attachments -->
                    <xsl:apply-templates select="." mode="task-attachments"/>
                </tr>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template match="item[@type='task']" mode="item-icon">
        <div style="width: 30px; height: 30px; display: inline-block;">
            <img width="30" height="30" src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-task.png')}" alt="" style="display: block; border: 0; outline: none; text-decoration: none;"></img>
        </div>
    </xsl:template>
    
    <xsl:template match="item" mode="task-attachments">
        <!-- Display the number of attachment -->
        <xsl:if test="nbAttachments != '' and nbAttachments != 0 or icsLink != ''">
            <td width="70" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top" align="right">
                <xsl:call-template name="table-vertical-spacer">
                    <xsl:with-param name="height">5</xsl:with-param>
                </xsl:call-template>
                <div style="line-height: 22px; font-size: 14px; font-family: {$font-family}; font-weight: 300;">
			        <xsl:if test="nbAttachments != '' and nbAttachments != 0">
	                    <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-clip.png')}" i18n:attr="alt" alt="plugin.workspaces:PROJECT_MAIL_NOTIFICATION_BODY_ATTACHMENT_ICON_ALT" width="15" height="11" valign="top"/>
	                    <!-- A deep link to the task or the attachment should be set here -->
	                    <span style="color: {$text-color};"><xsl:value-of select="nbAttachments"/></span>
			        </xsl:if>
			        
			        <xsl:if test="nbAttachments != '' and nbAttachments != 0 and icsLink != ''">
			                    &#160;
			        </xsl:if>
                    <!-- ICS icon -->
                    <xsl:if test="icsLink != ''">
                        <a href="{icsLink}">
                            <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-time.png')}" i18n:attr="alt" alt="plugin.workspaces:PROJECT_MAIL_NOTIFICATION_BODY_ATTACHMENT_ICON_ALT" width="15" height="11" valign="top"/>
                        </a>
                    </xsl:if>
                </div>
            </td>
        </xsl:if>
        
    </xsl:template>
    
    
    <!-- no separator for items with comments -->
    <xsl:template match="item[@type='task'][comments/comment]" mode="item-separator-style"/>
    
    <xsl:template match="item[@type='task']" mode="item-additional-content">
        <xsl:param name="isLast"/>
        
        <!-- We stick the comment inside the element -->
        <xsl:apply-templates select="comments/comment"/>
    </xsl:template>
    
    
</xsl:stylesheet>