/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { defineStore } from 'pinia'

/**
 * Pinia store for project filters
 */
export const useProjectFiltersStore = defineStore('projectFilters', {
    state: () => (
    {
        filterByName: '', // Filter by name
        filterByCategory: '' // Filter by category
    }),
    getters: {
        /**
         * Check if there is any filter applied
         * @returns {boolean} true if there is at least one filter
         */
        isFilter: state => {
            return state.filterByName.length > 0 || state.filterByCategory.length > 0;
        }
    },
    actions:
    {
        /**
         * set the filter by name
         * @param {string} name the name to filter by
         */
        setByName(name) 
        {
            this.filterByName = name;
        },

        /**
         * set the filter by category
         * @param {string} category the category to filter by
         */
        setByCategory(category) 
        {
            this.filterByCategory = category;
        },
    }

})

