/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.activitystream;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.ActionResultGenerator;

/**
 * Get the activities for activity stream
 *
 */
public class ActivityStreamServiceAction extends ServiceableAction
{
    private ActivityStreamServiceComponent _activityStreamServiceComponent;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _activityStreamServiceComponent = (ActivityStreamServiceComponent) smanager.lookup(ActivityStreamServiceComponent.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        int limit = parameters.getParameterAsInteger("max-results", Integer.MAX_VALUE);
        
        boolean allActivities = parameters.getParameterAsBoolean("all", false);
        boolean markAsRead = parameters.getParameterAsBoolean("mark-as-read", false);
        
        Map<String, Object> activityStream = _activityStreamServiceComponent.getActivityStream(limit, allActivities, markAsRead);
        
        ObjectModelHelper.getRequest(objectModel).setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, activityStream);
        
        return EMPTY_MAP;
    }
}
