/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.ametys.core.observation.Event;
import org.ametys.plugins.explorer.ObservationConstants;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType.ResourceReference;
import org.ametys.plugins.workspaces.project.objects.Project;

/**
 * {@link ActivityType} implementation for document deletion
 */
public class DocumentDeletedActivityType extends AbstractDocumentsActivityType
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_RESOURCE_DELETED);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        // File data
        String resourceName = (String) parameters.get(ObservationConstants.ARGS_NAME);
        String resourceOldName = (String) parameters.get("object.old.name");
        String resourceId = (String) parameters.get(ObservationConstants.ARGS_ID);
        String mimeType = (String) parameters.get(ObservationConstants.ARGS_RESOURCE_MIME_TYPE);
        
        activity.setValue(FILE_DATA_NAME, new ResourceReference(resourceId, resourceName, resourceOldName, mimeType, null));
    }
    

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity)
    {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        
        String projectName = activity.getValue(PROJECT_NAME);
        Project project = _projectManager.getProject(projectName);
        
        json.put("fileUrl", _documentModule.getModuleUrl(project));
        
        return json;
    }
}
