/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.jcr;

import javax.jcr.Node;

import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.resources.CalendarResource;

/**
 * Default implementation of an {@link Calendar}, backed by a JCR node.<br>
 */
public class JCRCalendarResource extends DefaultAmetysObject<JCRCalendarResourceFactory> implements CalendarResource
{
    /** Attribute id */
    public static final String ATTRIBUTE_CALENDAR_RESOURCE_ID = "calendarResourceId";
    /** Attribute title */
    public static final String ATTRIBUTE_TITLE = "title";
    /** Attribute icon */
    public static final String ATTRIBUTE_ICON = "icon";
    /** Attribute instructions */
    public static final String ATTRIBUTE_INSTRUCTIONS = "instructions";
    
    /**
     * Creates an {@link JCRCalendarResource}.
     * @param node the node backing this {@link AmetysObject}
     * @param parentPath the parentPath in the Ametys hierarchy
     * @param factory the DefaultAmetysObjectFactory which created the AmetysObject
     */
    public JCRCalendarResource(Node node, String parentPath, JCRCalendarResourceFactory factory)
    {
        super(node, parentPath, factory);
    }

    public String getTitle()
    {
        return getValue(ATTRIBUTE_TITLE);
    }

    public void setTitle(String title)
    {
        setValue(ATTRIBUTE_TITLE, title);
    }

    public String getInstructions()
    {
        return getValue(ATTRIBUTE_INSTRUCTIONS);
    }

    public void setInstructions(String instructions)
    {
        setValue(ATTRIBUTE_INSTRUCTIONS, instructions);
    }

    public String getIcon()
    {
        return getValue(ATTRIBUTE_ICON);
    }

    public void setIcon(String icon)
    {
        setValue(ATTRIBUTE_ICON, icon);
    }
    
    public ModifiableIndexableDataHolder getDataHolder()
    {
        ModifiableRepositoryData repositoryData = new JCRRepositoryData(getNode());
        return new DefaultModifiableModelAwareDataHolder(repositoryData, _getFactory().getCalendarResourceModel());
    }

    public String getCalendarResourceId()
    {
        return getValue(ATTRIBUTE_CALENDAR_RESOURCE_ID);
    }
    
    public void setCalendarResourceId(String id)
    {
        setValue(ATTRIBUTE_CALENDAR_RESOURCE_ID, id);
    }
}
