/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.tag.TagProvider;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.ui.StaticClientSideElement;

/**
 * Static client side element for the categories tool
 */
public class CategoriesToolClientSideElement extends StaticClientSideElement
{
    /** The tag provider extension point */
    protected CategoryProviderExtensionPoint _tagProviderEP;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _tagProviderEP = (CategoryProviderExtensionPoint) smanager.lookup(CategoryProviderExtensionPoint.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        List<Script> scripts = new ArrayList<>();

        TagProvider<Category> tagProvider = _tagProviderEP.getExtension(CategoryJCRProvider.class.getName());
        List<String> cssUrls = tagProvider.getCSSUrls(contextParameters);
        
        for (Script script : super.getScripts(ignoreRights, contextParameters))
        {
            Script cloneScript = ClientSideElementHelper.cloneScript(script);
            for (String cssUrl : cssUrls)
            {
                cloneScript.getCSSFiles().add(new ScriptFile(cssUrl));
            }
            scripts.add(cloneScript);
        }
        
        return scripts;
    }
}
