/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;

/**
 * Action to join a project with opened inscription status
 */
public class AskToJoinProjectAction extends ServiceableAction
{
    private ProjectsCatalogueManager _projectsCatalogueManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(manager);
        
        _projectsCatalogueManager = (ProjectsCatalogueManager) smanager.lookup(ProjectsCatalogueManager.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String projectId = request.getParameter("projectId");
        String message = request.getParameter("message");
        return _projectsCatalogueManager.askToJoinProject(projectId, message);
    }
}
