/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.notification.schedule;

import java.time.ZonedDateTime;

import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper.Frequency;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Implementation to send a mail with the summary of all notification for the past day
 */
public class SendDailyNotificationSummarySchedulable extends AbstractSendNotificationSummarySchedulable
{
    @Override
    protected I18nizableText getI18nSubject()
    {
        String i18nKey = "PROJECT_MAIL_NOTIFICATION_SUBJECT_SUMMARY_DAILY";
        return new I18nizableText("plugin." + _pluginName, i18nKey);
    }
    
    @Override
    protected Frequency getFrequency()
    {
        return Frequency.DAILY;
    }

    @Override
    protected ZonedDateTime getTimeFrameLimit()
    {
        return ZonedDateTime.now().minusDays(1);
    }
}

