/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.objects;

import javax.jcr.Node;

import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.activities.DefaultActivityHolderFactory;
import org.ametys.plugins.workspaces.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.site.SiteManager;

/**
 * {@link AmetysObjectFactory} for creating traversable {@link Project}.
 */
public class ProjectFactory extends DefaultActivityHolderFactory
{
    /** Site manager */
    protected SiteManager _siteManager;
    
    private ModelItemTypeExtensionPoint _projectDataTypeExtensionPoint;

    @Override
    public Project getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new Project(node, parentPath, this);
    }
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
        _projectDataTypeExtensionPoint = (ModelItemTypeExtensionPoint) manager.lookup(ModelItemTypeExtensionPoint.ROLE_PROJECT);
    }
    
    SiteManager _getSiteManager()
    {
        return _siteManager;
    }
    
    ModelItemTypeExtensionPoint getProjectDataTypeExtensionPoint()
    {
        return _projectDataTypeExtensionPoint;
    }
    
    Logger getFactoryLogger()
    {
        return getLogger();
    }
}
