<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver ametys">
    
    <xsl:import href="plugin:link-directory://pages/services/directory/directory_1.0.xsl"/> 
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('css/services/linkdirectory-default.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        
        <div id="link-directory-{$uniqueId}">
        	<xsl:attribute name="class">link-directory-body<xsl:if test="/links/link/@pictureType != ''"><xsl:text> pictures</xsl:text></xsl:if></xsl:attribute>
            <ul class="links">
                <xsl:apply-templates select="/links/link[not(@unknownPage) and @userLink !='true']">
                    <xsl:sort select="@user-selected='true'" order="descending"/>
                </xsl:apply-templates>
            </ul>
        </div>
        
        <xsl:if test="/links/link[@userLink ='true']">
            <div id="user-link-directory-{$uniqueId}">
                <h1><i18n:text i18n:key="PLUGINS_LINK_DIRECTORY_MY_SHORTCUTS" i18n:catalogue="skin.{$skin}"/></h1>
                <ul class="user-links">
                    <xsl:apply-templates select="/links/link[@userLink ='true']">
                        <xsl:sort select="@user-selected='true'" order="descending"/>
                    </xsl:apply-templates>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-picture">
        <xsl:if test="@pictureType != '' and (@pictureId or @picturePath or @pictureGlyph)">
            <div class="link-picture">
                <a href="{@url}" onclick="window.open(this.href); return false;" >
                    <xsl:if test="normalize-space(@title) != ''">
                        <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
                    </xsl:if>
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'glyph'">
                            <span class="link-glyph {@pictureGlyph}" style="font-size: 50px"></span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="id">
                                <xsl:choose>
                                    <xsl:when test="@pictureType = 'resource'">
                                        <xsl:value-of select="@pictureId"/>
                                    </xsl:when>
                                    <xsl:when test="@pictureType = 'external'">
                                        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:variable>
                                <img src="{resolver:resolveBoundedImage(@imageType, $id, 50, 50)}">
                                    <xsl:attribute name="alt"><xsl:value-of select="@pictureAlternative"/></xsl:attribute>
                                </img>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-themes">
        <xsl:if test="themes/theme">
           <div class="link-themes">
                <ul>
                    <xsl:for-each select="themes/theme">
                        <xsl:sort select="."/>
                        <li class="link-theme">
                            <xsl:value-of select="."/>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-link-remove-text"/>
    
</xsl:stylesheet>