<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		exclude-result-prefixes="ametys">
		
	<xsl:import href="plugin:web://pages/services/filtered-contents/list_3.3.xsl"/>		
	
    <xsl:variable name="common-service-css-class-name">filtered-contents filtered-contents-<xsl:value-of select="$view"/> last-publications</xsl:variable>
    
    <!-- Used by common -->         
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('css/services/filtered-contents.css')}" media="screen, print, handheld"/>
    </xsl:template>  
		
    <xsl:template match="content">
        <li>
            <xsl:variable name="href"><xsl:call-template name="get-read-more"/></xsl:variable>
            <a href="{$href}" class="read-more" title="En savoir plus">
                <xsl:call-template name="publication-date"/>
                <xsl:apply-templates select="html/body/div[contains(@class, 'ametys-cms-content')]/node()" mode="move-hierarchy">
                    <xsl:with-param name="level">2</xsl:with-param>
                </xsl:apply-templates>
                
                <div class="abstract-blur"></div>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="publication-date">
        <xsl:variable name="pubDate" select=".//meta[@name = 'lastValidatedAtRaw']/@content"/>
        
        <xsl:if test="$pubDate != ''">
        <span class="publication-date txt_and_icn">
            <img src="{ametys:skinURL('img/icon/Date.svg')}" alt="date" class="g-mr-7" />
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd/MM/yyyy"><xsl:value-of select="$pubDate" /></i18n:date>
            <span class="hideOnTime">
                <text><i18n:text i18n:key="SKIN_CONTENT_PANEL_LAST_VALIDATION_AT" i18n:catalogue="skin.{$skin}" /></text><i18n:time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="short"><xsl:value-of select="$pubDate" /></i18n:time>
            </span>
        </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="get-read-more">
        <xsl:value-of select="html/body/div[contains(@class, 'ametys-cms-content')]//*[@class='content-read-more']//a[@class='url']/@href"/>
    </xsl:template>
    
    <xsl:template match="p[@class='content-read-more']" mode="move-hierarchy"/>
    
    <xsl:template match="div[@class='tags']" mode="move-hierarchy"/>
</xsl:stylesheet>		
