<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
		
	<xsl:import href="plugin:web://pages/services/search-pages/search_3.3.xsl"/>		
	
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('css/services/search.css')}" media="screen, print, handheld"/>
    </xsl:template> 	
    
    <xsl:template name="hit-page">
        <li>
            <xsl:attribute name="class">hit page<xsl:text> </xsl:text>
                <xsl:call-template name="common-utils-class"/>
            </xsl:attribute>
            <xsl:call-template name="hit-page-title" />
            <xsl:call-template name="hit-path" />
            <xsl:call-template name="hit-scoring"/>
            <xsl:call-template name="hit-excerpt"/>
            <xsl:call-template name="hit-multisite"/>
            <xsl:call-template name="hit-lastvalidation"/>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-path">
        <xsl:variable name="path" select="substring-after(uri, '/')"/>
    
        <xsl:if test="substring-before($path, '/') != ''">
            <div class="service-search-path">
	            <xsl:call-template name="path-cut">
	                <xsl:with-param name="fullPath" select="$path"/>
                    <xsl:with-param name="remainingPath" select="$path"/>
	                <xsl:with-param name="site" select="siteName"/>
	                <xsl:with-param name="lang" select="substring-before(uri, '/')"/>
	            </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="path-cut">
        <xsl:param name="fullPath"/>
        <xsl:param name="remainingPath"/>
        <xsl:param name="donePath"/>
        <xsl:param name="lang"/>
        <xsl:param name="site"/>
        
        <xsl:variable name="beginingOfThePath">
            <xsl:choose>
                <xsl:when test="substring-before($remainingPath, '/') = ''"><xsl:value-of select="$remainingPath"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="substring-before($remainingPath, '/')"/></xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:variable name="currentPagePath" select="concat($donePath, $beginingOfThePath)"/>
    
        <xsl:value-of select="ametys:pageTitle($site, $lang, $currentPagePath)"/>
        
        <xsl:variable name="treatedPath" select="concat($currentPagePath, '/')"/>
        <xsl:variable name="remainingPath" select="substring($fullPath, string-length($treatedPath) + 1)"/>
        
        <xsl:if test="$remainingPath != '' and substring-before($remainingPath, '/') != ''">
            <xsl:text> &gt; </xsl:text>
            <xsl:call-template name="path-cut">
                <xsl:with-param name="remainingPath" select="$remainingPath"/>
                <xsl:with-param name="fullPath" select="$fullPath"/>
                <xsl:with-param name="donePath" select="$treatedPath"/>
                <xsl:with-param name="site" select="$site"/>
                <xsl:with-param name="lang" select="$lang"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>		
