<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
		exclude-result-prefixes="ametys">
	
    <xsl:import href="plugin:web://pages/services/sitemap/sitemap_3.3.xsl"/>			
    <xsl:import href="skin://stylesheets/config/config.xsl"/>	
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('css/services/sitemap.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function(){
                $j(".caret").on('click', function() {
                    this.parentElement.querySelector(".nested").classList.toggle("active");
                    this.classList.toggle("caret-down");
                    return false;
                  });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="page-list">
        <xsl:variable name="highlight-restricted"><xsl:if test="$conf-layout-highlight-restricted-page = 'true'"> highlight-restricted</xsl:if></xsl:variable>
        
        <xsl:if test="/sitemap/page">
            <ul id="{$id}" class="sitemap {$highlight-restricted}">
                <xsl:apply-templates select="/sitemap/page"/>
            </ul>
        </xsl:if>    
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var _getAmetysUserCb = function(user)
                {
                    if (user)
                    {
                        $j('#<xsl:value-of select="$id"/>').removeClass('hide-restricted');
                    }
                    else
                    {
                        $j('#<xsl:value-of select="$id"/>').addClass('hide-restricted');
                    }
                }
                
                getAmetysUser(_getAmetysUserCb);
            });
        </script>
    </xsl:template>
    
    <xsl:template match="page">
        <li>
            <xsl:if test="@restricted"><xsl:attribute name="class">restricted</xsl:attribute></xsl:if>
            <xsl:if test="page"><span class="caret"></span></xsl:if>
            <a href="{resolver:resolve('page', @id)}" title="{@long-title}">
                <xsl:value-of select="@title"/>
            </a>
            <xsl:if test="page">
                <ul class="nested">
                    <xsl:apply-templates select="page"/>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
</xsl:stylesheet>		
