<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys resolver">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>	

    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:variable name="displayedTitle">
            <xsl:choose>
                <xsl:when test="$page-id != ''"><xsl:value-of select="ametys:pageTitle($page-id)"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$title"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <h1>
            <span class="content-title summary"><xsl:value-of select="$displayedTitle"/></span>
            <xsl:if test="$subtitle != ''">
                <br/><span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
            </xsl:if>
        </h1>
    </xsl:template>
    
</xsl:stylesheet>
