<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:exsl="http://exslt.org/common"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">
    
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:template name="fo-edition-button-edit">
        <xsl:param name="contentId"/>
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_EDIT" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="tooltipI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDITION_EDIT')"/>
        
        <xsl:if test="$contentId != ''">       
            <xsl:variable name="editId" select="substring-after(math:random(), '.')" />
            
            <xsl:if test="ametys-front-edition:hasFrontEditionRight()">
                <li>
                    <script type="text/javascript">
                        var firstContentId = "<xsl:value-of select="/cms/page/pageContents/zone[@name='default']/zoneItem/information[type = 'CONTENT']/contentId"/>";
                        
                        function _editcontent_<xsl:value-of select="$editId"/>()
                        {
                            if (AmetysFrontEdition.modifiableContents &amp;&amp; AmetysFrontEdition.modifiableContents[firstContentId])
                            {
                                var editBtn = $j('.ametys-front-edition-button');
                                if (editBtn.length > 0)
                                {
                                    editBtn.get(0).click();
                                }
                            }
                            else
                            {   
                                var alertBtn = $j('#alert-edition-btn');
                                if (alertBtn.length > 0)
                                {
                                    alertBtn.get(0).click();
                                }
                            }
                        }
                    </script>
                    <a href="javascript:void(0)" onclick="_editcontent_{$editId}()"
                        data-toggle="tooltip" data-placement="top" title="{$tooltipI18nKey}" i18n:attr="title">
                        <span class="btn-icon docicon-edit g-font-size-16 g-mr-10"></span>
                        <span class="btn-txt"><xsl:copy-of select="$text"/></span>
                    </a>
                    <a id="alert-edition-btn" style="display: none;" href="#alert-edition" data-modal-target="#alert-edition" data-modal-effect="fadein">Launch Alert</a>
                    <div id="alert-edition" class="text-left g-max-width-600 g-bg-yellow g-overflow-y-auto g-pa-20" style="display: none;">
                        <button type="button" class="close" onclick="Custombox.modal.close();">
                            <span class="g-color-white" aria-hidden="true">×</span>
                        </button>
                        <div class="media">
                            <span class="d-flex g-mr-10 g-mt-5">
                                <i class="icon-ban g-font-size-25"></i>
                            </span>
                            <span class="media-body align-self-center">
                                <i18n:text i18n:key="SKIN_FO_EDITION_UNMODIFIABLE_ALERT" i18n:catalogue="skin.{$skin}"/>
                            </span>
                        </div>
                    </div>
                </li>
             </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="fo-edition-button-unpublish">
        <xsl:param name="contentId"/>
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_UNPUBLISH" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="tooltipI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDITION_UNPUBLISH')"/>
        
        <xsl:if test="$contentId != ''">       
            <xsl:call-template name="ametys-front-edition-content-workflow-button">
                <xsl:with-param name="content-id" select="$contentId"/>
                <xsl:with-param name="workflow-id" select="'10'"/>
                <xsl:with-param name="workflow-text"><span class="svg-fill"><xsl:call-template name="svg-actions-unpublish"/></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
                <xsl:with-param name="title-i18n" select="$tooltipI18nKey"/>
                <xsl:with-param name="edition-mode-only" select="false()"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="fo-edition-button-tag">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_TAG" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="tooltipI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDITION_TAG')"/>
        
        <xsl:call-template name="ametys-front-edition-insert-tag-page-button">
            <xsl:with-param name="page-id" select="ametys:pageId()"/>
            <xsl:with-param name="button-text"><span class="btn-icon docicon-tag g-font-size-16 g-mr-10"></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
            <xsl:with-param name="title-i18n" select="$tooltipI18nKey"/>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="fo-edition-button-addcontent">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_ADD_CONTENT" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="tooltipI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDITION_ADD_CONTENT')"/>
        
        <xsl:call-template name="ametys-front-edition-add-content-button">
            <xsl:with-param name="page-id" select="/cms/page/@id"/>
            <xsl:with-param name="content-types" select="'org.ametys.web.default.Content.article'"/>
            <xsl:with-param name="zone-name" select="'default'"/>
            <xsl:with-param name="content-title"><i18n:text i18n:key="FRONT_EDITION_EMPTY_ARTICLE_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="locale" select="$lang"/>
            <xsl:with-param name="title-i18n" select="$tooltipI18nKey"/>
            <xsl:with-param name="button-text"><span class="svg-fill"><xsl:call-template name="svg-actions-addcontent"/></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-add-page">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_ADD_PAGE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:variable name="parentPageId">
            <xsl:choose>
                <xsl:when test="/cms/inputData/sitemap/page[@sitemap:name = 'index' and @sitemap:current]"><xsl:value-of select="/cms/inputData/sitemap/@sitemap:id"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="ametys:pageId()"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="ametys-front-edition-insert-create-page-button">
            <xsl:with-param name="page-id" select="$parentPageId"/>
            <xsl:with-param name="button-text"><span class="btn-icon docicon-newpage g-font-size-16 g-mr-10"></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="class">g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14</xsl:with-param>
            <xsl:with-param name="callback">function(page)
                {
                    var path = AmetysFrontEdition.CONTEXT_PATH + "/" + "<xsl:value-of select="/cms/page/metadata/sitemap"/>" + "/" + page.getPath() + ".html";
                    window.location.href = path;
                }
            </xsl:with-param>
            <xsl:with-param name="config">{
                "force": true,
                "workflowInitActionId": "1", 
                "workflowEditActionId": "42", 
                "show-card-type" : false,           
                "show-card-content" : false,
                "show-card-tags" : false,
                "default-pagetype" : "template",
                "default-template" : "page",
                "default-pagecontent-type" : "contenttype",
                "default-contenttype" :  "org.ametys.web.default.Content.article",
                "default-content-title" : "Nouvel article",
                "default-contenttype-label" : "Article",
                "content-createViewName": null, // Force automatic view creation to avoid the use of 'creation' or 'default-edition'
                "content-editFormValues": {"content.input.content": "&lt;p>&#160;&lt;/p>"},
                "pagecontent-service" : false}
                </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-rename-page">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_RENAME" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:call-template name="ametys-front-edition-insert-rename-page-button">
            <xsl:with-param name="page-id" select="ametys:pageId()"/>
            <xsl:with-param name="button-text"><span class="btn-icon docicon-rename g-font-size-16 g-mr-10"></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-delete-page">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_DELETE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:call-template name="ametys-front-edition-insert-delete-page-button">
            <xsl:with-param name="page-id" select="ametys:pageId()"/>
            <xsl:with-param name="button-text"><span class="btn-icon docicon-delete g-font-size-16 g-mr-10"></span><span class="btn-txt"><xsl:copy-of select="$text"/></span></xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-open-in-bo">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_SEE_IN_BACKOFFICE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:if test="$rendering-context != 'back'">
            <li>
                <a
                    class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-7 g-px-20 g-font-size-14"
                    href="{ametys:config('cms.url')}/{$site}/index.html?uitool=uitool-page,id:'{ametys:pageId()}'" target="_blank">
                    <span class="btn-icon docicon-open g-font-size-16 g-mr-10"></span>
                    <span class="btn-txt"><xsl:copy-of select="$text"/></span>
                </a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-add-tags">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_ADD_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <li>
            <a class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14" href="#!">
                <span class="svg-fill-path svg-circle">
                    <xsl:call-template name="svg-add-tag"></xsl:call-template>
                </span>
                <span class="btn-txt"><xsl:copy-of select="$text"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="fo-edition-menuitem-move-page">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_MOVE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:variable name="currentPage" select="/cms/inputData/sitemap//page[@sitemap:current = 'true']"/>
        <xsl:variable name="parentId" select="$currentPage/parent::*[local-name() = 'page' or local-name() = 'sitemap']/@sitemap:id"/>
        <xsl:variable name="currentPos" select="count($currentPage/preceding-sibling::page) + 1"/>
        <xsl:variable name="nbPages" select="count($currentPage/../page)"/>
        
        <xsl:if test="$nbPages &gt; 1">
            <li class="morelist__has-submenu">
                <a href="#!">
                    <span class="btn-icon docicon-move g-font-size-16 g-mr-10"></span>
                    <span class="btn-txt"><xsl:copy-of select="$text"/></span>
                </a>
                <ul class="list-unstyled user__panel__dropdown g-brd-around g-brd-secondary-light-v2 g-bg-white rounded g-py-7 u-shadow-v1-3 sub-morelist">
                    <xsl:call-template name="ametys-front-edition-insert-move-page-up-button">
                        <xsl:with-param name="page-id" select="$currentPage/@sitemap:id"/>
                        <xsl:with-param name="page-parent-id" select="$parentId"/>
                        <xsl:with-param name="page-pos" select="$currentPos"/>
                        <xsl:with-param name="number-of-pages" select="$nbPages"/>
                        <xsl:with-param name="button-text"><span class="svg-stroke"><xsl:call-template name="svg-move-up"/></span><span><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_MOVE_UP" i18n:catalogue="skin.{$skin}"/></span></xsl:with-param>
                        <xsl:with-param name="class">g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14</xsl:with-param>
                        <xsl:with-param name="edition-mode-only" select="false()"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="ametys-front-edition-insert-move-page-down-button">
                        <xsl:with-param name="page-id" select="$currentPage/@sitemap:id"/>
                        <xsl:with-param name="page-parent-id" select="$parentId"/>
                        <xsl:with-param name="page-pos" select="$currentPos"/>
                        <xsl:with-param name="number-of-pages" select="$nbPages"/>
                        <xsl:with-param name="button-text"><span class="svg-stroke"><xsl:call-template name="svg-move-down"/></span><span><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_MOVE_DOWN" i18n:catalogue="skin.{$skin}"/></span></xsl:with-param>
                        <xsl:with-param name="class">g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14</xsl:with-param>
                        <xsl:with-param name="edition-mode-only" select="false()"/>
                    </xsl:call-template>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>
    
    <!-- Override -->
    <xsl:template name="ametys-front-edition-insert-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        
        <li>
            <a class="{$class}" title="{$title-i18n}" i18n:attr="title" href="javascript:void(0)" onclick="{$javascript-function}"><xsl:copy-of select="$button-text"/></a>
        </li>
    </xsl:template>
    
</xsl:stylesheet>