<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">

    <xsl:import href="skin://stylesheets/config/config.xsl" />
    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/zones.xsl" />
    <xsl:import href="skin://stylesheets/menus.xsl" />
    <xsl:import href="skin://stylesheets/fo-edition.xsl"/>
    <xsl:import href="skin://stylesheets/footer.xsl"/>
    <xsl:import href="skin://stylesheets/others.xsl"/>
    <xsl:import href="skin://stylesheets/svg.xsl"/>
    <xsl:import href="skin://stylesheets/search.xsl"/>

    <xsl:variable name="sitemap" select="/cms/inputData/sitemap"/>
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')" />
    
    <!-- There is side navigation if there is at least one visible page (except index page) -->
    <xsl:variable name="no-side-nav" select="not($sitemap/page[@sitemap:path != 'index' and not(@sitemap:invisible)])"/>
    <!-- Left side navigation is fixed only if there is no right navigation -->
    <xsl:variable name="fixed-side-nav" select="$conf-layout-right-navigation != 'true' or /cms/inputData/sitemap/page[@sitemap:current and not(@sitemap:name = 'index')]"/>

	<!-- + | BASE + -->
	<xsl:template name="template">
		<html>
			<xsl:call-template name="head" />
            <xsl:call-template name="body" />
		</html>
	</xsl:template>
    
    <xsl:template name="body">
        <body class="bg-body bg-body--min" id="topScroll" onload="PR.prettyPrint();">
            <div id="overlaySection" onclick="void(0)"></div>
            
            <div class="wrapper content-moved-down">
                <xsl:variable name="raw-footer"><xsl:call-template name="footer"/></xsl:variable>
                <xsl:if test="string-length($raw-footer) = 0">
                    <xsl:attribute name="class">wrapper content-moved-down no-footer</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="header" />
                <xsl:call-template name="center"/>
            </div>
            
            <xsl:call-template name="footer" />
        </body>
    </xsl:template>
    
    <xsl:template name="header">
        <header id="js-header"
            class="u-header u-header--sticky-top u-header--toggle-section u-header--change-appearance theme-header"
            data-header-fix-moment="300"
            data-no-side-nav="{$no-side-nav}"
            data-fix-side-nav="{$fixed-side-nav}">
            <div class="u-header__section u-header__section--light" data-header-fix-moment-classes="g-py-0">
                <nav
                    class="navbar navbar-expand-lg g-pa-30 d-flex align-items-center justify-content-between theme-navbar">
    
                    <div class="header__left"><!-- header__left -->
                        <xsl:call-template name="logo"/>
                        <xsl:call-template name="switch-languages"/>
                        <xsl:call-template name="header-top-title"/>
                    </div><!-- header__left END -->
    
                    <div class="header__right"><!-- header__right -->
                        <xsl:call-template name="top-search"/>
                        <xsl:call-template name="account"/>
                        <xsl:call-template name="responsible-toggle-button"/>
                    </div><!-- header__right END -->
                </nav>
            </div>
            <xsl:if test="$fixed-side-nav != true()">
                <xsl:call-template name="retractable-side-nav" />
            </xsl:if>
        </header><!-- End Header -->
    </xsl:template>
    
    <xsl:template name="header-top-title">
        <h1 class="header__top__title"><xsl:value-of select="ametys:siteParameter('title')"/></h1>
    </xsl:template>
    
    <xsl:template name="logo">
        <a href="{$site-uri-prefix}/{$lang}/index.html" class="navbar-brand theme-logo"><!-- Logo -->
            <img src="{ametys:skinURL('img/logo-white.png')}" alt="skin.{$skin}:SKIN_SITE_TITLE" i18n:attr="alt" data-logo="white" />
            <img src="{ametys:skinURL('img/logo.png')}" alt="skin.{$skin}:SKIN_SITE_TITLE" i18n:attr="alt" data-logo="colorful" />
        </a><!-- End Logo -->
    </xsl:template>
    
    <xsl:template name="switch-languages">
        <xsl:if test="$languages/*[not(@current)]">
            <div class="top__lang"><!-- top__lang -->
                <xsl:for-each select="$languages/*">
                    <xsl:choose>
                        <xsl:when test="@current = 'true'">
                            <a href="#!" class="active"><xsl:value-of select="local-name()"/></a>
                        </xsl:when>
                        <xsl:otherwise>
                            <a href="{.}"><xsl:value-of select="local-name()"/></a>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </div><!-- top__lang END -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="switch-languages-mobile">
        <xsl:if test="$languages/*[not(@current)]">
            <div class="mobile-set-panel">
                <div class="mobile-switch-lang g-rounded-2">
                    <xsl:for-each select="$languages/*">
                        <xsl:choose>
                            <xsl:when test="@current = 'true'">
                                <a href="#!" class="active">
                                    <i18n:text i18n:key="SKIN_TRANSLATION_TITLE_{local-name()}" i18n:catalogue="skin.{$skin}"/>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <a href="{.}"><i18n:text i18n:key="SKIN_TRANSLATION_TITLE_{local-name()}" i18n:catalogue="skin.{$skin}"/></a>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="account">
        <div class="d-inline-block g-valign-middle g-pos-rel g-ml-25--sm g-ml-15">
            <xsl:call-template name="account-user-menu"/>
            <xsl:call-template name="account-log-in"/>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                    var _getAmetysUserCb = function(user)
                    {
                        if (user)
                        {
                            $j('#userMenuItem').find('.usermenu__item-text').html(user.fullname);
                            $j('#userMenuItem').show();
                            $j('#userConnectItem').hide();
                        }
                        else
                        {
                            $j('#userMenuItem').hide();
                            $j('#userConnectItem').show();
                        }
                    }
                    
                    getAmetysUser(_getAmetysUserCb);
                });
            </script>
        </div>
    </xsl:template>
    
    <xsl:template name="account-user-menu">
        <div id="userMenuItem" style="display: none">
            <div id="account-dropdown-invoker"
                class="media align-items-center float-right g-text-underline--none--hover g-cursor-pointer user__panel"
                aria-controls="account-dropdown" aria-haspopup="true" aria-expanded="false"
                data-dropdown-event="click" data-dropdown-target="#account-dropdown"
                data-dropdown-type="css-animation" data-dropdown-duration="300"
                data-dropdown-hide-on-scroll="false" data-dropdown-animation-in="fadeIn"
                data-dropdown-animation-out="fadeOut">
                <div class="user__panel_icn">
                    <svg width="20px" height="20px" viewBox="0 0 13 15" version="1.1"
                        xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g class="userIcn" id="Documentation---Inner-Page" transform="translate(-749.000000, -296.000000)">
                                <g id="Group-11" transform="translate(396.000000, 275.000000)">
                                    <g id="Group-17" transform="translate(46.000000, 17.000000)">
                                        <g id="Group-16" transform="translate(304.000000, 0.000000)">
                                            <path
                                                d="M6.2890625,5.58072917 C7.1484418,4.72134987 8.17707734,4.29166667 9.375,4.29166667 C10.5729227,4.29166667 11.6015582,4.72134987 12.4609375,5.58072917 C13.3203168,6.44010846 13.75,7.46874401 13.75,8.66666667 C13.75,9.39583698 13.5742205,10.0859342 13.2226562,10.7369792 C12.871092,11.3880241 12.3958363,11.9088522 11.796875,12.2994792 C12.9427141,12.7942733 13.867184,13.5559844 14.5703125,14.5846354 C15.273441,15.6132864 15.625,16.7656186 15.625,18.0416667 L14.375,18.0416667 C14.375,16.6614514 13.8867236,15.4830778 12.9101562,14.5065104 C11.9335889,13.529943 10.7552152,13.0416667 9.375,13.0416667 C7.99478477,13.0416667 6.81641113,13.529943 5.83984375,14.5065104 C4.86327637,15.4830778 4.375,16.6614514 4.375,18.0416667 L3.125,18.0416667 C3.125,16.7656186 3.47655898,15.6132864 4.1796875,14.5846354 C4.88281602,13.5559844 5.80728594,12.7942733 6.953125,12.2994792 C6.35416367,11.9088522 5.87890801,11.3880241 5.52734375,10.7369792 C5.17577949,10.0859342 5,9.39583698 5,8.66666667 C5,7.46874401 5.4296832,6.44010846 6.2890625,5.58072917 Z M11.5625,6.47916667 C10.9635387,5.85416354 10.2343793,5.54166667 9.375,5.54166667 C8.5156207,5.54166667 7.77995098,5.84765319 7.16796875,6.45963542 C6.55598652,7.07161764 6.25,7.80728737 6.25,8.66666667 C6.25,9.52604596 6.55598652,10.2617157 7.16796875,10.8736979 C7.77995098,11.4856801 8.5156207,11.7916667 9.375,11.7916667 C10.2343793,11.7916667 10.970049,11.4856801 11.5820313,10.8736979 C12.1940135,10.2617157 12.5,9.52604596 12.5,8.66666667 C12.5,7.80728737 12.1875031,7.07812799 11.5625,6.47916667 Z"
                                                id="Icon-/-User"></path>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                </div>
                <div class="media-body user__panel__name">
                    <span class="d-block g-color-white g-font-size-13">
                        <span class="usermenu__item-text "></span>
                        <i class="icon-arrow-down g-font-size-10 g-ml-5"></i>
                    </span>
                </div>
            </div>
            
            <!-- User actions -->
            <xsl:call-template name="account-actions" />
        </div>
    </xsl:template>  
    
    <xsl:template name="account-log-in">    
        <div id="userConnectItem">
            <!-- Log In -->
            <xsl:variable name="login-url">
                <xsl:choose>
                    <xsl:when test="ametys:pageId() != ''">
                        <xsl:value-of select="ametys:siteUriPrefix()" /><xsl:text>/_authenticate?requestedURL=</xsl:text><xsl:value-of select="ametys:siteUriPrefix()" /><xsl:text>/</xsl:text><xsl:value-of select="$lang" /><xsl:text>/</xsl:text><xsl:value-of select="$sitemap//page[@sitemap:current = 'true']/@sitemap:path" /><xsl:text>.html</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$site-uri-prefix"/><xsl:text>/</xsl:text><xsl:value-of select="$lang" /><xsl:text>/index.html</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <a href="{$login-url}" class="btn btn-md u-btn-teal theme-btn-teal g-font-size-14 g-py-12 g-px-16 g-ml-20">
                <i18n:text i18n:key="SKIN_LOGIN" i18n:catalogue="skin.{$skin}" />
            </a>
            <a href="{$login-url}" class="show-md">
                <svg width="20px" height="20px" viewBox="0 0 13 15" version="1.1"
                    xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="vertical-align: middle">
                    <title lang="{$lang}"><i18n:text i18n:key="SKIN_LOGIN" i18n:catalogue="skin.{$skin}" /></title>
                    <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g class="userIcn" id="Documentation---Inner-Page" transform="translate(-749.000000, -296.000000)">
                            <g id="Group-11" transform="translate(396.000000, 275.000000)">
                                <g id="Group-17" transform="translate(46.000000, 17.000000)">
                                    <g id="Group-16" transform="translate(304.000000, 0.000000)">
                                        <path
                                            d="M6.2890625,5.58072917 C7.1484418,4.72134987 8.17707734,4.29166667 9.375,4.29166667 C10.5729227,4.29166667 11.6015582,4.72134987 12.4609375,5.58072917 C13.3203168,6.44010846 13.75,7.46874401 13.75,8.66666667 C13.75,9.39583698 13.5742205,10.0859342 13.2226562,10.7369792 C12.871092,11.3880241 12.3958363,11.9088522 11.796875,12.2994792 C12.9427141,12.7942733 13.867184,13.5559844 14.5703125,14.5846354 C15.273441,15.6132864 15.625,16.7656186 15.625,18.0416667 L14.375,18.0416667 C14.375,16.6614514 13.8867236,15.4830778 12.9101562,14.5065104 C11.9335889,13.529943 10.7552152,13.0416667 9.375,13.0416667 C7.99478477,13.0416667 6.81641113,13.529943 5.83984375,14.5065104 C4.86327637,15.4830778 4.375,16.6614514 4.375,18.0416667 L3.125,18.0416667 C3.125,16.7656186 3.47655898,15.6132864 4.1796875,14.5846354 C4.88281602,13.5559844 5.80728594,12.7942733 6.953125,12.2994792 C6.35416367,11.9088522 5.87890801,11.3880241 5.52734375,10.7369792 C5.17577949,10.0859342 5,9.39583698 5,8.66666667 C5,7.46874401 5.4296832,6.44010846 6.2890625,5.58072917 Z M11.5625,6.47916667 C10.9635387,5.85416354 10.2343793,5.54166667 9.375,5.54166667 C8.5156207,5.54166667 7.77995098,5.84765319 7.16796875,6.45963542 C6.55598652,7.07161764 6.25,7.80728737 6.25,8.66666667 C6.25,9.52604596 6.55598652,10.2617157 7.16796875,10.8736979 C7.77995098,11.4856801 8.5156207,11.7916667 9.375,11.7916667 C10.2343793,11.7916667 10.970049,11.4856801 11.5820313,10.8736979 C12.1940135,10.2617157 12.5,9.52604596 12.5,8.66666667 C12.5,7.80728737 12.1875031,7.07812799 11.5625,6.47916667 Z"
                                            id="Icon-/-User"></path>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
               </svg>
           </a>
       </div>
    </xsl:template>
    
    <xsl:template name="account-actions">
        <ul id="account-dropdown"
            class="js-mega-menu list-unstyled user__panel__dropdown g-width-200 g-brd-around g-brd-secondary-light-v2 g-bg-white rounded g-pos-abs g-right-0 g-py-7 u-shadow-v1-3"
            aria-labelledby="account-dropdown-invoker">
            
            <xsl:call-template name="user-menuitem-subscribe"/><!-- Subscribe (be careful, can work only on no-cacheable page)  -->
            <xsl:call-template name="user-menuitem-add-favorites"/><!-- Add to favorites -->
            <xsl:call-template name="user-menuitem-my-favorites"/><!-- My favorites -->
            <xsl:call-template name="user-menuitem-open-in-bo"/><!-- Open page in CMS -->
            
            <!-- Logout -->
            <xsl:if test="ametys:pageId() != ''">
                <li>
                    <a
                        class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-7 g-px-20 g-font-size-14"
                        href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html">
                        <span class="btn-icon docicon-logout g-font-size-16 g-mr-8"></span>
                        <span><i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/></span>
                    </a>
                </li>
            </xsl:if>
        </ul>
    </xsl:template>
    
    <xsl:template name="responsible-toggle-button">
        <xsl:if test="not($no-side-nav)">
            <button class="navbar-toggler theme-nav-toggler navbar-toggler-right btn g-line-height-1 g-brd-none g-pa-0 g-right-0 g-ml-15--sm g-ml-0 js-side-nav"
                            type="button"
                            aria-label="Toggle navigation"
                            aria-expanded="false"
                            aria-controls="navBar"
                            data-toggle="collapse"
                            data-target="#navBar"
                            data-hssm-class="u-side-nav--mini u-sidebar-navigation-v1--mini"
                            data-hssm-body-class="u-side-nav-mini"
                            data-hssm-is-close-all-except-this="true"
                            data-hssm-target="#sideNav">
                <span class="hamburger hamburger--slider">
                <span class="hamburger-box">
                    <span class="hamburger-inner"></span>
                </span>
                </span>
                <!-- Sidebar Toggler -->
                <!-- <a class="js-side-nav u-header__nav-toggler d-flex align-self-center ml-auto" href="#!" >
                        <i class="hs-admin-align-left"></i>
                    </a> -->
                    <!-- End Sidebar Toggler -->
            </button>
        </xsl:if>
        <!-- End Responsive Toggle Button -->
    </xsl:template>
    
    <xsl:template name="retractable-side-nav">
        <xsl:if test="not($no-side-nav)">
            <div class="side-nav-btn">
                <!-- button to expand/collapse side navigation -->
                <input id="side-nav-btn-input" type="checkbox" /><span></span><span></span><span></span><label for="side-nav-btn-input"></label>
                <xsl:call-template name="side-nav"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="side-nav">
        <div id="sideNav">
        	<xsl:attribute name="class">
        		<xsl:if test="$conf-layout-right-navigation != 'true' or $fixed-side-nav">col-xl-3 col-lg-4 col-md-5 col-12 </xsl:if>
        		<xsl:text>u-sidebar-navigation-v1 u-sidebar-navigation--dark</xsl:text>
        	</xsl:attribute>
            <xsl:choose>
                <xsl:when test="$conf-layout-dropdown-navigation = 'true'">
                    <xsl:call-template name="sidebar-dropdown">
                        <xsl:with-param name="pages" select="$sitemap/page"/>
                    </xsl:call-template>
                    <xsl:call-template name="side-nav-menu">
                        <xsl:with-param name="rootPage" select="$sitemap/page[@sitemap:in-path]"></xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="side-nav-menu">
                        <xsl:with-param name="rootPage" select="$sitemap"></xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:call-template name="switch-languages-mobile"/>
        </div>
    </xsl:template>
    
    <xsl:template name="center">
        <div class="container g-pt-90"><!-- container -->
            <xsl:call-template name="main-zone"/>
        </div>
    </xsl:template>

</xsl:stylesheet>
