<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
	xmlns:math="java.lang.Math"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	extension-element-prefixes="ametys math sitemap resolver">

	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <xsl:template name="top-search">
        <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag('SEARCH')"/>
        
        <xsl:if test="$searchPage">
            <div class="top__search_wrap"><!-- top__search_wrap -->
                <form method="post" id="form-top-search" action="{resolver:resolve('page', $searchPage/@id)}">
                    <input name="textfield" id="form-top-search-input" type="text" autocomplete="off" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT" i18n:attr="placeholder" 
                            class="top__search_input" 
                            data-ametys-fastsearch="page" 
                            data-ametys-fastsearch-result-classname="top__search__result" 
                            data-ametys-fastsearch-result-classname-hide="d-none" 
                            data-ametys-fastsearch-result-ul-classname="list-unstyled searchFieldResults__list" 
                            data-ametys-fastsearch-result-li-classname="searchFieldResults__list_item" 
                            data-ametys-fastsearch-result-link-classname="g-font-size-18 color-grey" 
                            data-ametys-fastsearch-result-path-classname="g-font-size-12 color-grey path"/>
                    
                    <input name="submit-form" type="hidden" value="mainSearch" />
                    <a href="javascript:void(0)" onclick="$('#form-top-search').submit();" class="top__search_wrap_icn hide-md">
                        <img src="{ametys:skinURL('img/icon/Search_White.svg')}" alt="skin.{$skin}:SKIN_SEARCH_SUBMIT" i18n:attr="alt" data-searchicn="white" />
                        <svg class="searchIcn" data-searchicn="color" width="17" height="17" viewBox="0 0 17 17" xmlns="http://www.w3.org/2000/svg">
                            <title><i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/></title>
                            <path
                                d="M5.43 1.836C6.654.612 8.125 0 9.844 0c1.719 0 3.19.612 4.414 1.836 1.224 1.224 1.836 2.695 1.836 4.414 0 1.719-.612 3.19-1.836 4.414-1.224 1.224-2.695 1.836-4.414 1.836-1.485 0-2.8-.469-3.946-1.406l-4.96 5L0 15.156l5-4.96A6.054 6.054 0 0 1 3.594 6.25c0-1.719.612-3.19 1.836-4.414zm7.93.898c-.964-.99-2.136-1.484-3.516-1.484s-2.559.488-3.535 1.465C5.332 3.69 4.844 4.87 4.844 6.25c0 1.38.488 2.559 1.465 3.535.976.977 2.155 1.465 3.535 1.465 1.38 0 2.558-.488 3.535-1.465.976-.976 1.465-2.155 1.465-3.535 0-1.38-.495-2.552-1.485-3.516z"
                                fill-rule="evenodd" />
                        </svg>
                    </a>
                    <a href="javascript:void(0)" class="top__search_wrap_icn show-md mobile-md">
                        <img src="{ametys:skinURL('img/icon/Search_White.svg')}" alt="skin.{$skin}:SKIN_SEARCH_SUBMIT" i18n:attr="alt" data-searchicn="white" />
                        <svg class="searchIcn" data-searchicn="color" width="17" height="17" viewBox="0 0 17 17" xmlns="http://www.w3.org/2000/svg">
                            <title><i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/></title>
                            <path
                                d="M5.43 1.836C6.654.612 8.125 0 9.844 0c1.719 0 3.19.612 4.414 1.836 1.224 1.224 1.836 2.695 1.836 4.414 0 1.719-.612 3.19-1.836 4.414-1.224 1.224-2.695 1.836-4.414 1.836-1.485 0-2.8-.469-3.946-1.406l-4.96 5L0 15.156l5-4.96A6.054 6.054 0 0 1 3.594 6.25c0-1.719.612-3.19 1.836-4.414zm7.93.898c-.964-.99-2.136-1.484-3.516-1.484s-2.559.488-3.535 1.465C5.332 3.69 4.844 4.87 4.844 6.25c0 1.38.488 2.559 1.465 3.535.976.977 2.155 1.465 3.535 1.465 1.38 0 2.558-.488 3.535-1.465.976-.976 1.465-2.155 1.465-3.535 0-1.38-.495-2.552-1.485-3.516z"
                                fill-rule="evenodd" />
                        </svg>
                    </a>
                </form>
                <div class="top__search_wrap__mobile g-pa-30 u-shadow-v1-3">
                    <div class="g-pos-rel">
                        <form method="post" id="form-top-search-md" action="{resolver:resolve('page', $searchPage/@id)}">
                            <input id="form-top-search-md-input" name="textfield" autocomplete="off" type="text" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT" i18n:attr="placeholder" class="top__search_input"
                                    data-ametys-fastsearch="page" 
                                    data-ametys-fastsearch-result-classname="top__search__result" 
                                    data-ametys-fastsearch-result-classname-hide="d-none" 
                                    data-ametys-fastsearch-result-ul-classname="list-unstyled searchFieldResults__list" 
                                    data-ametys-fastsearch-result-li-classname="searchFieldResults__list_item" 
                                    data-ametys-fastsearch-result-link-classname="g-font-size-18 color-grey" 
                                    data-ametys-fastsearch-result-path-classname="g-font-size-12 color-grey path"/>
                            <input name="submit-form" type="hidden" value="mainSearch" />
                            <a href="javascript:void(0)" onclick="$('#form-top-search-md').submit();" class="top__search_wrap__mobile__btn">
                                <svg class="searchIcn" width="17" height="17" viewBox="0 0 17 17" xmlns="http://www.w3.org/2000/svg">
                                    <title><i18n:text i18n:key="SKIN_SEARCH_SUBMIT" i18n:catalogue="skin.{$skin}"/></title>
                                    <path
                                        d="M5.43 1.836C6.654.612 8.125 0 9.844 0c1.719 0 3.19.612 4.414 1.836 1.224 1.224 1.836 2.695 1.836 4.414 0 1.719-.612 3.19-1.836 4.414-1.224 1.224-2.695 1.836-4.414 1.836-1.485 0-2.8-.469-3.946-1.406l-4.96 5L0 15.156l5-4.96A6.054 6.054 0 0 1 3.594 6.25c0-1.719.612-3.19 1.836-4.414zm7.93.898c-.964-.99-2.136-1.484-3.516-1.484s-2.559.488-3.535 1.465C5.332 3.69 4.844 4.87 4.844 6.25c0 1.38.488 2.559 1.465 3.535.976.977 2.155 1.465 3.535 1.465 1.38 0 2.558-.488 3.535-1.465.976-.976 1.465-2.155 1.465-3.535 0-1.38-.495-2.552-1.485-3.516z"
                                        fill-rule="evenodd" />
                                </svg>
                            </a>
                        </form>
                    </div>
                </div>
            </div><!-- top__search_wrap END -->
            
            <script type="text/javascript">
                $j().ready(function() 
                {
                    $( "#form-top-search-input").keyup(function(e) {
                        if (e.key === "Enter")
                        {
                            $( "#form-top-search").submit();
                        }
                    });
                    
                    $( "#form-top-search-md").keyup(function(e) {
                        if (e.key === "Enter")
                        {
                            $( "#form-top-search-md").submit();
                        }
                    });
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-keywords-highlight">
        <script type="text/javascript" src="{ametys:skinURL('js/jquery.highlight-3.yui.js')}"></script>
        <script type="text/javascript">
            $j().ready(function()
            {
                var hlRegexp = new RegExp('[\?\&amp;]search-keywords=([^\?\&amp;#;]+)', 'i');
                var result = hlRegexp.exec(location.search);
                if (result != null &amp;&amp; result.length &gt; 1)
                {
                    var keywords = result[1].split(',');
                    for (var x = 0; x &lt; keywords.length; x++)
                    {
                        if (keywords[x] != '')
                        {
                        <xsl:for-each select="/cms/template-information/template/zone">
                            $j('#ametys-cms-zone-<xsl:value-of select="@id"/>').highlight($j.trim(decodeURIComponent(keywords[x])));
                        </xsl:for-each> 
                        }
                    }
                }
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>
