<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://stylesheets/main.xsl" />

    <xsl:template name="additionnal-css">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
    </xsl:template>
    
    <xsl:template name="body">
        <body class="bg-body loginPage">
            <div id="overlaySection" onclick="void(0)"></div>
    
            <div class="wrapper login_page">
                <xsl:call-template name="header" />
                <xsl:call-template name="center" />
            </div>
            <xsl:call-template name="footer" />
        </body>
    </xsl:template>
    
    <xsl:template name="center">
        <div class="content content--login"><!-- content -->
            <div class="login__section g-bg-white g-pa-30"><!-- login__section -->
                <xsl:call-template name="main-zone"/>
            </div><!-- login__section -->
        </div><!-- content END -->
    </xsl:template>
    
    <xsl:template name="header">
        <!-- Header -->
        <header id="js-header" class="u-header u-header--toggle-section u-header--change-appearance theme-header"
            data-header-fix-moment="300">
            <div class="u-header__section u-header__section--light" data-header-fix-moment-exclude="g-py-10"
                data-header-fix-moment-classes="g-py-0">
                <nav
                    class="navbar navbar-expand-lg g-pa-30 d-flex align-items-center justify-content-between theme-navbar">
    
                    <div class="header__left"><!-- header__left -->
                        <xsl:call-template name="logo" />
                        <xsl:call-template name="switch-languages" />
                        <xsl:call-template name="header-top-title" />
                    </div><!-- header__left END -->
    
                    <div class="header__right"><!-- header__right -->
                        <xsl:call-template name="top-search" />
                        <xsl:call-template name="account" />
                        <xsl:call-template name="responsible-toggle-button" />
                    </div><!-- header__right END -->
    
                </nav>
            </div>
        </header><!-- End Header -->
    </xsl:template>
    
    <xsl:template name="responsible-toggle-button"/>
</xsl:stylesheet>