<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

    <xsl:import href="skin://stylesheets/main.xsl" />
    
    <xsl:template name="center">
        <div class="row no-gutters g-pos-rel">
        	<xsl:if test="$fixed-side-nav">
            	<xsl:call-template name="side-nav"/>
            </xsl:if>
            <xsl:call-template name="main-content"/>
        </div>
        <!-- row END -->
    </xsl:template>
    
    <xsl:template name="main-content-cls">
        <xsl:variable name="cls-col-size">
            <xsl:choose>
                <xsl:when test="$fixed-side-nav">col col-xl-9 col-lg-8 cold-md-7 col-12</xsl:when>
                <xsl:otherwise>col col-xl-12 col-lg-12 cold-md-12 col-12</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="concat('col ', $cls-col-size, ' g-ml-0 bg-white vh-height')"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <xsl:variable name="mainContentCls"><xsl:call-template name="main-content-cls"/></xsl:variable>
        <div class="{$mainContentCls}">
            <div class="content__top__wrap">
                <xsl:call-template name="content-top" />
                <xsl:call-template name="content-panel" />
            </div>
            
            <xsl:choose>
                <xsl:when test="$conf-layout-right-navigation = 'true' and (($sitemap/page/page[@sitemap:in-path]/page and $conf-layout-dropdown-navigation = 'true') or ($conf-layout-dropdown-navigation != 'true' and $sitemap/page[@sitemap:in-path]/page))">
                    <div class="content content--paddin-sides">
                        <!-- row -->
                        <div class="row">
                            <!-- column -->
                            <div class="col-xl-9">
                                <!-- content__inner -->
                                <div class="content__inner">
                                    <xsl:call-template name="main-zone" />
            
                                    <xsl:call-template name="top-scroll-link"/>
                                </div>
                                <!-- content__inner END -->
                            </div>
                            <!-- column END -->
                            
                            <xsl:choose>
                                <xsl:when test="$conf-layout-dropdown-navigation = 'true'">
                                    <xsl:call-template name="side-nav-menu-inner">
                                        <xsl:with-param name="rootPage" select="$sitemap/page/page[@sitemap:in-path]"></xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="side-nav-menu-inner">
                                        <xsl:with-param name="rootPage" select="$sitemap/page[@sitemap:in-path]"></xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                        <!-- row END -->
                   </div>
                </xsl:when>
                <xsl:otherwise>
                    <div class="content content--pad2 content--padding">
                        <xsl:call-template name="main-zone" />
            
                        <xsl:call-template name="top-scroll-link"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
            
            </div>
        <!-- content block END -->
    </xsl:template>
    
    <xsl:template name="top-scroll-link">
        <a class="theme-js-go-to g-pb-30" href="#topScroll">
            <img src="{ametys:skinURL('/img/icon/arrow-up.png')}" alt="" />
            <span class="g-font-size-16 color-grey g-font-primary-light">
                <i18n:text i18n:key="SKIN_BACK_TO_TOP" i18n:catalogue="skin.{$skin}" />
            </span>
        </a>
    </xsl:template>
    
    <xsl:template name="content-top">
        <xsl:if test="ametys:pageId() != '' and not($sitemap/page[@sitemap:current = 'true' and @sitemap:path = 'index'])">
            <div class="content__top">
                <h1 class="main__title"><xsl:value-of select="ametys:pageLongTitle(ametys:pageId())" /></h1>
                <xsl:call-template name="breadcrumb"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-panel">
        <xsl:choose>
            <!-- FIXME Do not display in mobile mode -->
            <xsl:when test="/cms/page/pageContents/zone[@name='default']/zoneItem/information/type = 'CONTENT'">
                <div class="content__panel hide-md" style="display: none">
                    <xsl:call-template name="contributor-info"/>
                    <xsl:call-template name="fo-edition-actions"/><!-- Be careful, can be call only on cacheable page -->
                </div>
                <hr class="u-divider theme-divider g-my-0"/>
                <script type="text/javascript">
                    $j(document).ready(function() {
                        var displayContributorInfoInAnonymousMode = '<xsl:value-of select="$conf-layout-display-contributor-infos-in-anonymous-mode"/>' == 'true';
                        var _getAmetysUserCb = function(user)
                        {
                            if (user || displayContributorInfoInAnonymousMode)
                            {
                                $j('.content__panel').show(); // Show contributions info
                                $j('.u-divider').hide();
                                if (user)
                                {
                                    // Show FO actions
                                    $j('.content__panel').find('.panel__more').show();
                                }
                                else
                                {
                                    // Hide FO actions
                                    $j('.content__panel').find('.panel__more').hide();
                                }
                            }
                            else
                            {
                                $j('.content__panel').hide(); // Hide contributions info
                                $j('.u-divider').show();
                            }
                        }
                        
                        getAmetysUser(_getAmetysUserCb);
                    });
                </script>
            </xsl:when>
            <xsl:otherwise>
                <hr class="u-divider theme-divider g-my-0"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
</xsl:stylesheet>