<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver ametys">

    <xsl:import href="plugin:web://pages/frontoffice-login/logout.xsl"/>
    
    <xsl:template match="/">
		<html>
			<head>
				<title><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_HEAD" i18n:catalogue="plugin.web"/></title>
			</head>
			<body id="default">
                <h1 class="g-font-primary-light g-font-size-24 color-grey g-mb-25--sm g-mb-15"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_TITLE" i18n:catalogue="plugin.web"/></h1>
                <p class="g-font-primary-light g-font-size-14 color-grey g-mb-15"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_TEXT" i18n:catalogue="plugin.web"/></p>
                <xsl:variable name="requestedURL" select="ametys:requestParameter('requestedURL')"/>
                <xsl:if test="$requestedURL and $requestedURL != ''">
                    <p><a href="{$requestedURL}" class="portlet__link">
                    	<i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_LINK" i18n:catalogue="plugin.web"/>
                    	<xsl:text> </xsl:text>
                    	<img src="{ametys:skinURL('img/icon/Arrow_Next_green.svg')}" alt=""/>
                    </a></p>
                </xsl:if>
			</body>
		</html>
	</xsl:template>

</xsl:stylesheet>
