<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:date="http://exslt.org/dates-and-times"
        exclude-result-prefixes="ametys resolver sitemap"
        extension-element-prefixes="date">
        
    <xsl:import href="plugin:web://pages/services/filtered-contents/list_3.3.xsl"/>     
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="accordion-09" class="u-accordion" role="tablist" aria-multiselectable="true">
            <div class="card theme-card__accordion rounded-0 g-brd-none">
                <xsl:apply-templates select="/contents/content"/>
            </div>
        </div>
        
        <script type="text/javascript">
            $(document).on('ready', function () {
                $('#accordion-09').on('show.bs.collapse', function () {
                    var currentPosition = $(this).offset().top - 120;
                    $('html, body').animate({scrollTop: currentPosition}, 400);
                })
             });
        </script>
    </xsl:template>
    
    <xsl:template match="content">
        <div id="accordion-09-heading-0{position()}" class="u-accordion__header g-px-0 g-py-5" role="tab">
            <h4 class="g-font-weight-600 g-font-size-16 mb-0">
                <a class="collapsed u-link-v5 g-color-main g-color-primary--hover" href="#accordion-09-body-0{position()}"
                    data-toggle="collapse" data-parent="#accordion-09" aria-expanded="false" aria-controls="accordion-09-body-0{position()}">
                    <div class="alert__block__top g-mb-0">
                        <img src="{ametys:skinURL('img/icon/Info.svg')}" alt="Info"/>
                        <h3><xsl:value-of select="@title"/></h3>
                    </div>
                </a>
            </h4>
        </div>
        <div id="accordion-09-body-0{position()}" class="collapse" role="tabpanel" aria-labelledby="accordion-09-heading-0{position()}"
            data-parent="#accordion-09">
            <div class="u-accordion__body g-color-gray-dark-v5 g-px-0 g-py-5">
                <xsl:copy-of select="./html/body/div/node()" />
            </div>
        </div>
    </xsl:template>
        
</xsl:stylesheet>       
