<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		exclude-result-prefixes="ametys">
		
	<xsl:import href="plugin:web://pages/services/filtered-contents/list_3.3.xsl"/>		
	
    <!-- Used by common -->         
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('css/services/filtered-contents.css')}" media="screen, print, handheld"/>
    </xsl:template> 
    
    <xsl:template match="content">
       	<xsl:variable name="raw-is-title-visible">
	        <xsl:call-template name="common-service-body-nonempty-content-title-content">
    	        <xsl:with-param name="title" select="$service-title"/>
        	</xsl:call-template>  
		</xsl:variable>


		<li>
            <xsl:attribute name="class">content-list-item<xsl:text> </xsl:text>
                <xsl:call-template name="common-utils-class"/>
            </xsl:attribute>
            
            <!-- Insert title -->
            <xsl:choose>
                <xsl:when test="$raw-is-title-visible != ''"><h2><xsl:value-of select="html/head/title"/></h2></xsl:when>
                <xsl:otherwise><h1><xsl:value-of select="html/head/title"/></h1></xsl:otherwise>
            </xsl:choose>   
            
            <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level">
                    <xsl:choose>
                        <xsl:when test="$raw-is-title-visible != ''">3</xsl:when>
                        <xsl:otherwise>2</xsl:otherwise>
                    </xsl:choose>            
                </xsl:with-param>
            </xsl:apply-templates>                           
		</li>
	</xsl:template>
    
</xsl:stylesheet>		
