<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys resolver docbook">

	<xsl:import href="view://stylesheets/content/common.xsl"/>
	
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
        <xsl:if test="metadata/blocs/entry">
    		<div class="row g-mb-80--md g-mb-40">
    			<xsl:apply-templates select="metadata/blocs/entry"/>
             </div>
        </xsl:if>
	</xsl:template>
    
    <xsl:template match="entry">
        <div class="col-lg-4 col-md-6">
            <a href="{resolver:resolve('page', bloc-link)}" class="rounded-2 u-shadow-v1-3 g-pa-30 bg-white portlet g-mb-30">
                <div>
                    <h1 class="portlet__title"><xsl:value-of select="bloc-title"/></h1>
                    <div class="portlet__text">
                        <xsl:apply-templates select="bloc-content/docbook:article">
                            <xsl:with-param name="level" select="2"/>
                        </xsl:apply-templates>
                    </div>
                </div>
                <span class="portlet__link">
                    <xsl:choose>
                        <xsl:when test="bloc-link-title != ''"><xsl:value-of select="bloc-link-title"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="CONTENT_VIEW_READMORE" i18n:catalogue="plugin.cms"/></xsl:otherwise>
                    </xsl:choose>
                    <img src="{ametys:skinURL('/img/icon/Arrow_Next_green.svg')}" alt=""/>
                </span>
            </a>
        </div>
    </xsl:template>
</xsl:stylesheet>
