<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:exsl="http://exslt.org/common"
                            xmlns:math="java.lang.Math"
                            xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:subscribe="org.ametys.plugins.pagesubscription.page.helpers.PageSubscriptionXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys subscribe">
    
    <xsl:import href="service:link-directory://stylesheets/bookmarklet.xsl"/>
    
    <xsl:variable name="raw-languages">
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">fr</xsl:with-param></xsl:call-template>
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">en</xsl:with-param></xsl:call-template>
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">es</xsl:with-param></xsl:call-template>
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">it</xsl:with-param></xsl:call-template>
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">de</xsl:with-param></xsl:call-template>
        <xsl:call-template name="emulate-language"><xsl:with-param name="code">zh</xsl:with-param></xsl:call-template>
    </xsl:variable>
    <xsl:variable name="languages" select="exsl:node-set($raw-languages)"/>

    <xsl:template name="emulate-language">
        <xsl:param name="code"/>
        
        <xsl:choose>
            <xsl:when test="/cms/page/metadata/translations/*[local-name() = $code]">
                <xsl:variable name="pageId" select="/cms/page/metadata/translations/*[local-name() = $code]"/>
                <xsl:variable name="hrefResolved" select="resolver:resolve('page', $pageId)"/>
                <xsl:if test="$hrefResolved != ''">
                    <xsl:element name="{$code}">
                        <xsl:value-of select="$hrefResolved"/>
                    </xsl:element>
                </xsl:if>
            </xsl:when>
            <xsl:when test="ametys:pageExists(ametys:site(), $code, 'index')">
                <xsl:element name="{$code}">
                    <xsl:if test="$lang = $code"><xsl:attribute name="current">true</xsl:attribute></xsl:if>
                    <xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$code"/>/index.html
                </xsl:element>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="breadcrumb">
    	<a href="#" onclick="window.print();return false;" class="print"><i class="fa fa-print"></i></a>
        <ul class="u-list-inline theme-breadcrumbs">
            <xsl:if test="/cms/inputData/sitemap/page[@sitemap:name = 'index']">
                <li class="list-inline-item g-mr-7">
                    <a class="u-link-v5 link-color" href="{$site-uri-prefix}/{$lang}/index.html"><xsl:value-of select="/cms/inputData/sitemap/page[@sitemap:name = 'index']/@sitemap:title"/></a>
                    <xsl:if test="/cms/inputData/sitemap//page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']">
                        <i class="fa fa-angle-right g-ml-7"></i>
                    </xsl:if>
                </li>
            </xsl:if>
            <xsl:for-each select="/cms/inputData/sitemap//page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']">
                <xsl:choose>
                    <xsl:when test="not(@sitemap:current)">
                        <li class="list-inline-item g-mr-7">
                            <a class="u-link-v5 link-color" href="{$site-uri-prefix}/{$lang}/{@sitemap:path}.html"><xsl:value-of select="@sitemap:title" /></a>
                            <i class="fa fa-angle-right g-ml-7"></i>
                        </li>
                    </xsl:when>
                    <xsl:otherwise>
                        <li class="list-inline-item color-grey">    
                            <span><xsl:value-of select="@sitemap:title" /></span>
                        </li>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="contributor-info">
        <xsl:choose>
            <xsl:when test="/cms/page/pageContents/zone[@name='default']/zoneItem/information/type = 'CONTENT'">
                <div class="expand-width g-mr-15">
                    <div class="d-flex align-items-center full-height flex-wrap">
                        <!-- Last validation -->
                        <xsl:variable name="lastModified" select="/cms/page/pageContents/zone[@name='default']/zoneItem/html/head/meta[@name = 'lastValidatedAtRaw']/@content" />
                        <span class="txt_and_icn g-mr-20">
                            <img src="{ametys:skinURL('img/icon/Date.svg')}" alt="date" class="g-mr-7" />
                            <!-- FIXME AWTWEB-701 <i class="docicon-date g-mr-7 g-font-size-16"></i> -->
                            <span class="hideOn">
                                <i18n:text i18n:key="SKIN_CONTENT_PANEL_LAST_VALIDATION" i18n:catalogue="skin.{$skin}" />
                            </span>
                            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd/MM/yyyy"><xsl:value-of select="$lastModified" /></i18n:date>
                            <span class="hideOnTime">
                                <text><i18n:text i18n:key="SKIN_CONTENT_PANEL_LAST_VALIDATION_AT" i18n:catalogue="skin.{$skin}" /></text><i18n:time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="short"><xsl:value-of select="$lastModified" /></i18n:time>
                            </span>
                        </span>
                        <!-- Last contributor -->
                        <xsl:variable name="lastContributorUI" select="/cms/page/pageContents/zone[@name='default']/zoneItem/html/head/meta[@name = 'lastContributor']/@content" />
                        <xsl:variable name="lastContributor" select="ametys:user($lastContributorUI)"/>
                        <xsl:if test="$lastContributor/user">
                            <span class="txt_and_icn g-mr-20">
                                <img src="{ametys:skinURL('img/icon/User.svg')}" alt="user" class="g-mr-7" />
                                <!-- FIXME AWTWEB-701 <i class="docicon-user g-mr-7 g-font-size-16"></i> -->
                                <span class="show_first_letter">
                                    <span><xsl:value-of select="substring($lastContributor/user/firstname, 1, 1)"/></span><xsl:value-of select="substring($lastContributor/user/firstname, 2)"/>
                                </span>
                                <span class="show_first_letter">
                                    <span><xsl:value-of select="substring($lastContributor/user/lastname, 1, 1)"/></span><xsl:value-of select="substring($lastContributor/user/lastname, 2)"/>
                                </span>
                            </span>
                        </xsl:if>
                        <xsl:call-template name="into-favorites"/>
                        <xsl:call-template name="restricted"/>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="expand-width g-mr-15"><!--  empty- --></div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="into-favorites">
        <xsl:variable name="currentUrl" select="resolver:resolve('page', /cms/inputData/sitemap//page[@sitemap:current = 'true']/@sitemap:id, false(), true())"/>
        <xsl:if test="/cms/inputData/linkDirectory/links/link[@userLink = 'true' and @url=$currentUrl]">
            <span class="txt_and_icn g-mr-20">
                <img src="{ametys:skinURL('img/icon/MyFavorites.svg')}" alt="user" class="g-mr-7" />
                <!-- FIXME AWTWEB-701 <i class="docicon-favorite g-mr-7 g-font-size-16"></i> -->
                <span class="hideOn">
                    <i18n:text i18n:key="SKIN_CONTENT_PANEL_SAVED" i18n:catalogue="skin.{$skin}" />
                </span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="restricted">
    	<xsl:variable name="currentPageId" select="/cms/page/@id"/>
    	<xsl:value-of select="cms/page/inputData/sitemap//page[@sitemap:id = $currentPageId]/@sitemap:restricted"/>
    	
    	<xsl:if test="cms/inputData/sitemap//page[@sitemap:id = $currentPageId]/@sitemap:restricted='true'">
    		<span class="txt_and_icn">
                <i class="docicon-lock g-mr-7 g-font-size-16"></i>
                <span class="hideOn">
                    <i18n:text i18n:key="SKIN_CONTENT_RESTRICTED" i18n:catalogue="skin.{$skin}" />
                </span>
            </span>
        </xsl:if>
    </xsl:template>
    
    
    <!-- +
         | Be careful ! Because this template use ametys:user(), it cannot work on cacheable page.
         | Do not call this template on cacheable page
         + -->
    <xsl:template name="fo-edition-actions">
        <xsl:param name="nb-max-inline-actions">3</xsl:param>
        
        <xsl:variable name="contentId" select="/cms/page/pageContents/zone[@name='default']/zoneItem/information[type = 'CONTENT']/contentId"/>
        
        <xsl:variable name="fo-edition-actions">
            <actions>
                <xsl:if test="$contentId != '' and ametys:user() and ametys:renderingContext() = 'front' and ametys-front-edition:hasFrontEditionRight()">
                    <xsl:call-template name="fo-edition-button-edit"><!-- Edit content -->
                        <xsl:with-param name="contentId" select="$contentId"/>
                    </xsl:call-template>
                    <!-- <xsl:call-template name="fo-edition-button-unpublish">
                        <xsl:with-param name="contentId" select="$contentId"/>
                    </xsl:call-template> -->
                    <xsl:call-template name="fo-edition-button-tag"/><!-- Tag page -->
                    <xsl:call-template name="fo-edition-menuitem-add-page"/><!-- New page -->
                    <xsl:call-template name="fo-edition-menuitem-rename-page"/><!-- Rename page -->
                    <xsl:call-template name="fo-edition-menuitem-move-page"/><!-- Move page -->
                    <xsl:call-template name="fo-edition-menuitem-delete-page"/><!-- Delete page -->
                    <!-- <xsl:call-template name="fo-edition-menuitem-add-tags"/> -->
                    
                </xsl:if>
            </actions>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($fo-edition-actions)/actions/li">
            <div class="expand-width panel__more">
                <ul class="actions-list list-unstyled d-flex align-items-center justify-content-end expand-width-flexWrap">
                    <xsl:for-each select="exsl:node-set($fo-edition-actions)/actions/li[position() &lt; ($nb-max-inline-actions + 1)]">
                        <li>
                            <xsl:copy-of select="@*"/>
                            <xsl:apply-templates mode="fo-action-inline"/>
                        </li>
                    </xsl:for-each>
                    
                    <xsl:if test="count(exsl:node-set($fo-edition-actions)/actions/li) &gt; $nb-max-inline-actions">
                        <div class="d-inline-block g-valign-middle g-pos-rel more-list__wrap">
                            <div class="media align-items-center more-list g-px-15 rounded-2 more-list__wrap__item">
                                <xsl:call-template name="svg-more"/>
                                <div class="media-body user__panel__name link-color g-pr-0">
                                    <i18n:text i18n:key="SKIN_FO_EDITION_MORE_ACTIONS" i18n:catalogue="skin.{$skin}"/>
                                </div>
                            </div>
            
                            <ul class="list-unstyled g-width-200 more-list__wrap--dropdown g-brd-around g-brd-secondary-light-v2 g-py-7 u-shadow-v1-3">
                               <xsl:for-each select="exsl:node-set($fo-edition-actions)/actions/li[position() &gt; $nb-max-inline-actions]">
                                    <li>
                                        <xsl:copy-of select="@*"/>
                                        <xsl:apply-templates mode="fo-action-menu"/>
                                    </li>
                                </xsl:for-each>
                            </ul>
                        </div>
                    </xsl:if>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="a" mode="fo-action-inline">
        <xsl:copy>
            <xsl:copy-of select="@*[local-name() != 'class']"/>
            <xsl:attribute name="class">link_icn g-mr-20 g-mb-0--xl g-mb-5</xsl:attribute>
            <xsl:attribute name="data-toggle">tooltip</xsl:attribute>
            <xsl:attribute name="data-placement">top</xsl:attribute>
            
            <xsl:copy-of select="*"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="@*|node()" mode="fo-action-inline">
        <xsl:copy-of select="."/>
    </xsl:template>
    
    <xsl:template match="a" mode="fo-action-menu">
        <xsl:copy>
            <xsl:copy-of select="@*[local-name() != 'class']"/>
            <xsl:attribute name="class">g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14</xsl:attribute>
            <xsl:apply-templates mode="fo-action-menu"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="@*|node()" mode="fo-action-menu">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="fo-action-menu"/>
        </xsl:copy>
    </xsl:template>
    
    
    <!-- +
         | Be careful ! Because this template use ametys:user(), it cannot work on cacheable page.
         | Do not call this template on cacheable page
         + -->
    <xsl:template name="user-menuitem-subscribe">
        <xsl:param name="subscribe-text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_SUBSCRIBE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="unsubscribe-text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_UNSUBSCRIBE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:variable name="user" select="ametys:user()"/>
        
        <xsl:if test="$user and ametys:pageId()">
            <xsl:variable name="email"><xsl:if test="$user"><xsl:value-of select="$user/user/email"/></xsl:if></xsl:variable>
            <xsl:variable name="isRegistered" select="subscribe:isPageSubscriber($email)"/>
            
            <li>
                
                <a
                    class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-7 g-px-20 g-font-size-14"
                    href="javascript:void(0)"
                    onclick="_subscribe_to_page()">
                    <span class="btn-icon docicon-subscribe g-font-size-16 g-mr-8"></span>
                    <span id="subscribe-text-wrapper-{$uniqueId}"></span>
                </a>
                <script type="text/javascript">
                    var registered = <xsl:value-of select="$isRegistered"/>;
                    function _update_subscribe_mode()
                    {
                        $j('#subscribe-text-wrapper-<xsl:value-of select="$uniqueId"/>').html(registered ? "<xsl:copy-of select="$unsubscribe-text"/>" : "<xsl:copy-of select="$subscribe-text"/>");
                    }
                    
                    function _subscribe_to_page()
                    {
                        // send it in ajax
                        var data = {
                             "page-id": "<xsl:value-of select="ametys:pageId()"/>",
                             "email": "<xsl:value-of select="$email"/>",
                             "page-subscribe-action": registered ? "unsubscribe" : "subscribe",
                             "ajax": "true"
                        };
    
                        function result(data)
                        {
                             var s = "";
                             $j('errors error', data).each(function () { s += $j(this).text() + "\n"; });
                             if (s == "")
                             {
                                 var errors = $j('error > error', data);
                                 if (errors.length == 0)
                                 {
                                    registered = !registered;
                                    _update_subscribe_mode();
                                 }
                                 else
                                 {
                                     var errorInfo = "";
                                     $j.each(errors, function(i) {
                                         errorInfo += "\n* " + $j(errors[i]).text();
                                     }); 
                                     alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_DESCRIPTION"  i18n:catalogue="plugin.page-subscription"/>" + errorInfo)
                                 }
                             }
                             else
                             {
                                 alert(s);
                             }
                         }
                         
                         function handleError(jqXHR, textStatus, errorThrown)
                         {
                             alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_AJAX" i18n:catalogue="plugin.page-subscription"/>");
                         }
    
                         $j.ajax({
                             url: "<xsl:value-of select="$uri-prefix"/>/plugins/page-subscription/subscribe",
                             data: data,
                             type: 'post',
                             success: result,
                             error: handleError
                         });  
                    }
                    
                    _update_subscribe_mode();
                </script>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-menuitem-add-favorites">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_ADD_FAVORITES" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <li>
            <a class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14">
                <xsl:attribute name="href">
                    <xsl:variable name="js">
                       <xsl:call-template name="bookmarklet-javascript">
                           <xsl:with-param name="siteName" select='ametys:site()'/>
                           <xsl:with-param name="lang" select='ametys:lang()'/>
                           <xsl:with-param name="display-confirm" select="true()"/>
                           <xsl:with-param name="confirm-text" select="'plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_CONFIRM_TEXT'"/>
                           <xsl:with-param name="success-text" select="'plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_SUCCESS_TEXT'"/>
                           <xsl:with-param name="unauthenticated-user-text" select="'plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_UNAUTHENTICATED_USER_TEXT'"/>
                           <xsl:with-param name="already-exists-text" select="'plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_ALREADY_EXISTS_TEXT'"/>
                           <xsl:with-param name="unknown-error-text" select="'plugin.link-directory:PLUGINS_LINKDIRECTORY_BL_ERROR_UNKNOWN_TEXT'"/>
                       </xsl:call-template>
                    </xsl:variable>
                    <xsl:value-of select="normalize-space($js)"/>
                </xsl:attribute>
            
                <span class="btn-icon docicon-favorite g-font-size-16 g-mr-8"></span>
                <span><xsl:copy-of select="$text"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="user-menuitem-my-favorites">   
        <xsl:param name="text"><i18n:text i18n:key="SKIN_MY_FAVORITES" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:if test="/cms/inputData/linkDirectory/links/link[@userLink = 'true']">
            <li class="hs-has-sub-menu active">
                <a id="my-favorites-{generate-id()}" class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14" href="#" aria-haspopup="true" aria-expanded="false" aria-controls="my-favorites-{generate-id()}">
                    <span class="btn-icon docicon-favorite g-font-size-16 g-mr-8"></span>
                    <span><xsl:copy-of select="$text"/></span>
                </a>
                <ul class="hs-sub-menu list-unstyled g-brd-top g-brd-green g-brd-top-2 g-min-width-200 g-max-width-300 g-my-2" id="my-favorites-{generate-id()}" aria-labelledby="my-favorites-{generate-id()}">
                    <xsl:for-each select="/cms/inputData/linkDirectory/links/link[@userLink = 'true']">
                        <li class="dropdown-item">
                            <a href="{@url}" class="nav-link g-px-0 g-py-5 g-font-size-14">
                                <!-- <i class="btn-icon hs-icon hs-icon-arrow-right g-font-size-16 g-mr-8"></i>
                                <xsl:value-of select="@title"/> -->
                                <span class="btn-icon fa fa-angle-right g-font-size-16 g-mr-8"></span>
                                <span><xsl:value-of select="@title"/></span>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template name="user-menuitem-open-in-bo">
        <xsl:param name="text"><i18n:text i18n:key="SKIN_FO_EDITION_PAGE_SEE_IN_BACKOFFICE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:if test="$rendering-context != 'back'">
            <li>
                <a class="g-color-green-v1 g-color-gray-dark-v1--hover g-text-underline--none--hover g-py-5 g-px-20 g-font-size-14"
                   href="{ametys:config('cms.url')}/{$site}/index.html?uitool=uitool-page,id:'{ametys:pageId()}'" 
                   target="_blank">
                    <span class="btn-icon docicon-open g-font-size-16 g-mr-8"></span>
                    <span><xsl:copy-of select="$text"/></span>
                </a>
            </li>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>