<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">
    
    <xsl:template name="svg-new-page">
        <svg width="15px" height="16px" viewBox="0 0 15 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">
                <g id="Documentation---Inner-Page" transform="translate(-1604.000000, -117.000000)">
                    <g id="Icon-/-New-page" transform="translate(1604.000000, 117.000000)">
                        <path
                            d="M13.5,15.5 L1.5,15.5 C0.948,15.5 0.5,15.052 0.5,14.5 L0.5,1.5 C0.5,0.948 0.948,0.5 1.5,0.5 L13.5,0.5 C14.052,0.5 14.5,0.948 14.5,1.5 L14.5,14.5 C14.5,15.052 14.052,15.5 13.5,15.5 Z"
                            id="Shape" stroke="#555555"></path>
                        <path d="M0.5,3.5 L14.5,3.5" id="Shape" stroke="#555555"></path>
                        <path d="M7.5,6.5 L7.5,12.5" id="Shape" stroke="#1ABC9C"></path>
                        <path d="M4.5,9.5 L10.5,9.5" id="Shape" stroke="#1ABC9C"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-rename">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1254.000000, -294.000000)"
                    fill="#555555" fill-rule="nonzero">
                    <g id="Group-19" transform="translate(1255.000000, 291.000000)">
                        <g id="Icon-/-Edit" transform="translate(0.000000, 3.000000)">
                            <path
                                d="M0,16 C-0.276142375,16 -0.5,15.7761424 -0.5,15.5 C-0.5,15.2238576 -0.276142375,15 0,15 L14,15 C14.2761424,15 14.5,15.2238576 14.5,15.5 C14.5,15.7761424 14.2761424,16 14,16 L0,16 Z"
                                id="Shape"></path>
                            <path
                                d="M1.45148201,9.25562477 L0.687184271,12.3128157 L3.74437523,11.548518 L11.7928932,3.5 L9.5,1.20710678 L1.45148201,9.25562477 Z M9.85355339,0.146446609 L12.8535534,3.14644661 C13.0488155,3.34170876 13.0488155,3.65829124 12.8535534,3.85355339 L4.35355339,12.3535534 C4.28947398,12.4176328 4.20918404,12.4630922 4.12126781,12.4850713 L0.121267813,13.4850713 C-0.244922421,13.5766188 -0.576618808,13.2449224 -0.48507125,12.8787322 L0.51492875,8.87873219 C0.536907807,8.79081596 0.582367198,8.71052602 0.646446609,8.64644661 L9.14644661,0.146446609 C9.34170876,-0.0488155365 9.65829124,-0.0488155365 9.85355339,0.146446609 Z"
                                id="Shape"></path>
                            <path
                                d="M7.14644661,2.85355339 C6.95118446,2.65829124 6.95118446,2.34170876 7.14644661,2.14644661 C7.34170876,1.95118446 7.65829124,1.95118446 7.85355339,2.14644661 L10.8535534,5.14644661 C11.0488155,5.34170876 11.0488155,5.65829124 10.8535534,5.85355339 C10.6582912,6.04881554 10.3417088,6.04881554 10.1464466,5.85355339 L7.14644661,2.85355339 Z"
                                id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-subscribe">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-1604.000000, -232.000000)"
                    fill="#555555" fill-rule="nonzero">
                    <g id="Icon-/-Notification" transform="translate(1604.000000, 232.000000)">
                        <path
                            d="M9.5,13.5 C9.5,13.2238576 9.72385763,13 10,13 C10.2761424,13 10.5,13.2238576 10.5,13.5 C10.5,14.8811424 9.38114237,16 8,16 C6.61885763,16 5.5,14.8811424 5.5,13.5 C5.5,13.2238576 5.72385763,13 6,13 C6.27614237,13 6.5,13.2238576 6.5,13.5 C6.5,14.3288576 7.17114237,15 8,15 C8.82885763,15 9.5,14.3288576 9.5,13.5 Z"
                            id="Shape"></path>
                        <path
                            d="M0.5,12 C0.223857625,12 0,11.7761424 0,11.5 C0,11.2238576 0.223857625,11 0.5,11 L15.5,11 C15.7761424,11 16,11.2238576 16,11.5 C16,11.7761424 15.7761424,12 15.5,12 L0.5,12 Z"
                            id="Shape"></path>
                        <path
                            d="M15,11 C15.6666667,11 15.6666667,12 15,12 L14.5,12 C14.3776433,12 14.2655517,11.9560497 14.1786509,11.8830749 C13.0197641,11.5576614 12,10.59318 12,9.5 L12,5 C12,2.79114237 10.2088576,1 8,1 C5.79114237,1 4,2.79114237 4,5 L4,9.5 C4,10.8811424 2.88114237,12 1.5,12 C1.22385763,12 1,11.7761424 1,11.5 C1,11.2238576 1.22385763,11 1.5,11 C2.32885763,11 3,10.3288576 3,9.5 L3,5 C3,2.23885763 5.23885763,0 8,0 C10.7611424,0 13,2.23885763 13,5 L13,9.5 C13,10.2203324 14.0489828,11 15,11 Z"
                            id="Shape"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-open-in-cms">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-1604.000000, -289.000000)"
                    fill-rule="nonzero">
                    <g id="Icon-/-CMS" transform="translate(1604.000000, 289.000000)">
                        <path
                            d="M6,11 L4.5,11 C4.0704206,11 3.84083164,10.4940391 4.12371165,10.1707477 L7.62371165,6.1707477 C7.8229173,5.9430841 8.1770827,5.9430841 8.37628835,6.1707477 L11.8762883,10.1707477 C12.1591684,10.4940391 11.9295794,11 11.5,11 L10,11 L10,15.5 C10,15.7761424 9.77614237,16 9.5,16 L6.5,16 C6.22385763,16 6,15.7761424 6,15.5 L6,11 Z M8,7.25929613 L5.60188411,10 L6.5,10 C6.77614237,10 7,10.2238576 7,10.5 L7,15 L9,15 L9,10.5 C9,10.2238576 9.22385763,10 9.5,10 L10.3981159,10 L8,7.25929613 Z"
                            id="Shape" fill="#1ABC9C"></path>
                        <path
                            d="M3.5,13 C3.77614237,13 4,13.2238576 4,13.5 C4,13.7761424 3.77614237,14 3.5,14 L1.5,14 C0.671857625,14 0,13.3281424 0,12.5 L0,1.5 C0,0.671857625 0.671857625,0 1.5,0 L14.5,0 C15.3281424,0 16,0.671857625 16,1.5 L16,12.5 C16,13.3281424 15.3281424,14 14.5,14 L12.5,14 C12.2238576,14 12,13.7761424 12,13.5 C12,13.2238576 12.2238576,13 12.5,13 L14.5,13 C14.7758576,13 15,12.7758576 15,12.5 L15,1.5 C15,1.22414237 14.7758576,1 14.5,1 L1.5,1 C1.22414237,1 1,1.22414237 1,1.5 L1,12.5 C1,12.7758576 1.22414237,13 1.5,13 L3.5,13 Z"
                            id="Shape" fill="#555555"></path>
                        <path
                            d="M15.5,4 C15.7761424,4 16,4.22385763 16,4.5 C16,4.77614237 15.7761424,5 15.5,5 L0.5,5 C0.223857625,5 0,4.77614237 0,4.5 C0,4.22385763 0.223857625,4 0.5,4 L15.5,4 Z"
                            id="Shape" fill="#555555"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-delete">
        <svg width="15px" height="16px" viewBox="0 0 15 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-1604.000000, -346.000000)"
                    fill="#555555" fill-rule="nonzero">
                    <g id="Icon-/-Delete" transform="translate(1604.000000, 346.000000)">
                        <path
                            d="M1,6.5 C1,6.22385763 1.22385763,6 1.5,6 C1.77614237,6 2,6.22385763 2,6.5 L2,13.5 C2,14.3288576 2.67114237,15 3.5,15 L11.5,15 C12.3288576,15 13,14.3288576 13,13.5 L13,6.5 C13,6.22385763 13.2238576,6 13.5,6 C13.7761424,6 14,6.22385763 14,6.5 L14,13.5 C14,14.8811424 12.8811424,16 11.5,16 L3.5,16 C2.11885763,16 1,14.8811424 1,13.5 L1,6.5 Z"
                            id="Shape"></path>
                        <path
                            d="M0.5,4 C0.223857625,4 0,3.77614237 0,3.5 C0,3.22385763 0.223857625,3 0.5,3 L14.5,3 C14.7761424,3 15,3.22385763 15,3.5 C15,3.77614237 14.7761424,4 14.5,4 L0.5,4 Z"
                            id="Shape"></path>
                        <path
                            d="M6,1 L6,3.5 C6,3.77614237 5.77614237,4 5.5,4 C5.22385763,4 5,3.77614237 5,3.5 L5,0.5 C5,0.223857625 5.22385763,0 5.5,0 L9.5,0 C9.77614237,0 10,0.223857625 10,0.5 L10,3.5 C10,3.77614237 9.77614237,4 9.5,4 C9.22385763,4 9,3.77614237 9,3.5 L9,1 L6,1 Z"
                            id="Shape"></path>
                        <path
                            d="M7,7.5 C7,7.22385763 7.22385763,7 7.5,7 C7.77614237,7 8,7.22385763 8,7.5 L8,12.5 C8,12.7761424 7.77614237,13 7.5,13 C7.22385763,13 7,12.7761424 7,12.5 L7,7.5 Z"
                            id="Shape"></path>
                        <path
                            d="M10,7.5 C10,7.22385763 10.2238576,7 10.5,7 C10.7761424,7 11,7.22385763 11,7.5 L11,12.5 C11,12.7761424 10.7761424,13 10.5,13 C10.2238576,13 10,12.7761424 10,12.5 L10,7.5 Z"
                            id="Shape"></path>
                        <path
                            d="M4,7.5 C4,7.22385763 4.22385763,7 4.5,7 C4.77614237,7 5,7.22385763 5,7.5 L5,12.5 C5,12.7761424 4.77614237,13 4.5,13 C4.22385763,13 4,12.7761424 4,12.5 L4,7.5 Z"
                            id="Shape"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-move-page">
        <svg width="16px" height="15px" viewBox="0 0 16 15" version="1.1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---menu" transform="translate(-1639.000000, -409.000000)" fill="#555555"
                    fill-rule="nonzero">
                    <g id="Group-26" transform="translate(1373.000000, 332.000000)">
                        <g id="Group-25" transform="translate(242.000000, 0.000000)">
                            <g id="Icon-/-Move" transform="translate(24.000000, 77.000000)">
                                <path
                                    d="M7.5,8 C7.22385763,8 7,7.77614237 7,7.5 C7,7.22385763 7.22385763,7 7.5,7 L15.5,7 C15.7761424,7 16,7.22385763 16,7.5 C16,7.77614237 15.7761424,8 15.5,8 L7.5,8 Z"
                                    id="Shape"></path>
                                <path
                                    d="M11.1464466,3.85355339 C10.9511845,3.65829124 10.9511845,3.34170876 11.1464466,3.14644661 C11.3417088,2.95118446 11.6582912,2.95118446 11.8535534,3.14644661 L15.8535534,7.14644661 C16.0488155,7.34170876 16.0488155,7.65829124 15.8535534,7.85355339 L11.8535534,11.8535534 C11.6582912,12.0488155 11.3417088,12.0488155 11.1464466,11.8535534 C10.9511845,11.6582912 10.9511845,11.3417088 11.1464466,11.1464466 L14.7928932,7.5 L11.1464466,3.85355339 Z"
                                    id="Shape"></path>
                                <path
                                    d="M1,1 L1,14 L4,14 L4,1 L1,1 Z M0.5,0 L4.5,0 C4.77614237,0 5,0.223857625 5,0.5 L5,14.5 C5,14.7761424 4.77614237,15 4.5,15 L0.5,15 C0.223857625,15 0,14.7761424 0,14.5 L0,0.5 C0,0.223857625 0.223857625,0 0.5,0 Z"
                                    id="Rectangle-path"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-move-up">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="15" height="16" viewBox="0 0 15 16">
            <defs>
                <path id="57rya" d="M1404.5 424.5v-11"/>
                <path id="57ryb" d="M1409.5 418.5l-5-5-5 5"/>
                <path id="57ryc" d="M1411.5 409.5h-14"/>
            </defs>
            <g transform="translate(-1397 -409)">
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#57rya"/>
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#57ryb"/>
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#57ryc"/>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-move-down">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="15" height="16" viewBox="0 0 15 16">
            <defs>
                <path id="koaga" d="M1404.5 464.5v11"/>
                <path id="koagb" d="M1409.5 470.5l-5 5-5-5"/>
                <path id="koagc" d="M1411.5 479.5h-14"/>
            </defs>
            <g transform="translate(-1397 -464)">
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#koaga"/>
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#koagb"/>
                <use fill="#fff" fill-opacity="0" stroke="#555" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="50" xlink:href="#koagc"/>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-add-tag">
        <svg width="16px" height="18px" viewBox="0 0 16 18" version="1.1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---menu" transform="translate(-1639.000000, -465.000000)">
                    <g id="Group-26" transform="translate(1373.000000, 332.000000)">
                        <g id="Group-25" transform="translate(242.000000, 0.000000)">
                            <g id="Icon-/-Add-Tag" transform="translate(24.000000, 133.000000)">
                                <path
                                    d="M1,1 L1,6.79289322 L9,14.7928932 L14.7928932,9 L6.79289322,1 L1,1 Z M0.5,0 L7,0 C7.13260824,0 7.2597852,0.0526784202 7.35355339,0.146446609 L15.8535534,8.64644661 C16.0488155,8.84170876 16.0488155,9.15829124 15.8535534,9.35355339 L9.35355339,15.8535534 C9.15829124,16.0488155 8.84170876,16.0488155 8.64644661,15.8535534 L0.146446609,7.35355339 C0.0526784202,7.2597852 0,7.13260824 0,7 L0,0.5 C0,0.223857625 0.223857625,0 0.5,0 Z"
                                    id="Shape" fill="#555555" fill-rule="nonzero"></path>
                                <circle id="Ovals" fill="#555555" fill-rule="nonzero"
                                    transform="translate(12.000000, 4.000000) scale(-1, 1) translate(-12.000000, -4.000000) "
                                    cx="12" cy="4" r="1"></circle>
                                <circle id="Oval-2" fill="#FFFFFF" cx="9" cy="12" r="6"></circle>
                                <path
                                    d="M9.5,17 C7.01471863,17 5,14.9852814 5,12.5 C5,10.0147186 7.01471863,8 9.5,8 C11.9852814,8 14,10.0147186 14,12.5 C14,14.9852814 11.9852814,17 9.5,17 Z M9.5,16 C11.4329966,16 13,14.4329966 13,12.5 C13,10.5670034 11.4329966,9 9.5,9 C7.56700338,9 6,10.5670034 6,12.5 C6,14.4329966 7.56700338,16 9.5,16 Z"
                                    id="Oval" fill="#1ABC9C" fill-rule="nonzero"></path>
                                <path
                                    d="M9,10.5 C9,10.2238576 9.22385763,10 9.5,10 C9.77614237,10 10,10.2238576 10,10.5 L10,14.5 C10,14.7761424 9.77614237,15 9.5,15 C9.22385763,15 9,14.7761424 9,14.5 L9,10.5 Z"
                                    id="Shape" fill="#1ABC9C" fill-rule="nonzero"></path>
                                <path
                                    d="M7.5,13 C7.22385763,13 7,12.7761424 7,12.5 C7,12.2238576 7.22385763,12 7.5,12 L11.5,12 C11.7761424,12 12,12.2238576 12,12.5 C12,12.7761424 11.7761424,13 11.5,13 L7.5,13 Z"
                                    id="Shape" fill="#1ABC9C" fill-rule="nonzero"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-favorites">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="plugins-nav" transform="translate(-43.000000, -976.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Icon-/-MyFavorites" transform="translate(43.000000, 976.000000)">
                        <path d="M8,1.99662466 L6.13035343,5.78431245 C6.05751802,5.93186857 5.91674332,6.03414051 5.75390022,6.05780335 L1.57453848,6.66510929 L4.59898888,9.61294028 C4.71683497,9.72780094 4.77061741,9.89329427 4.74280976,10.0554899 L4.02899923,14.2189814 L7.76731176,12.2534436 C7.91298322,12.1768521 8.08701678,12.1768521 8.23268824,12.2534436 L11.9710008,14.2189814 L11.2571902,10.0554899 C11.2293826,9.89329427 11.283165,9.72780094 11.4010111,9.61294028 L14.4254615,6.66510929 L10.2460998,6.05780335 C10.0832567,6.03414051 9.94248198,5.93186857 9.86964657,5.78431245 L8,1.99662466 Z M5.34998778,5.1059937 L7.55164657,0.645687552 C7.73506444,0.274104149 8.26493556,0.274104149 8.44835343,0.645687552 L10.6500122,5.1059937 L15.5719002,5.82119665 C15.9820206,5.88079152 16.1457686,6.38479843 15.8489889,6.67405972 L12.2872277,10.1455896 L13.1278098,15.0485101 C13.1978368,15.4569618 12.7691124,15.7684136 12.4023118,15.5755564 L8,13.2608997 L3.59768824,15.5755564 C3.23088764,15.7684136 2.80216316,15.4569618 2.87219024,15.0485101 L3.71277231,10.1455896 L0.151011124,6.67405972 C-0.145768583,6.38479843 0.0179793882,5.88079152 0.428099783,5.82119665 L5.34998778,5.1059937 Z" id="Shape"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-more">
        <svg width="16px" height="3px" viewBox="0 0 16 3" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g class="moreIcn" id="Documentation---Main-Page" transform="translate(-1813.000000, -301.000000)">
                        <g id="Group" transform="translate(1809.000000, 291.000000)">
                            <path d="M4.90430975,10.640625 C5.16472772,10.380207 5.46420389,10.25 5.80274725,10.25 C6.14129061,10.25 6.43425643,10.3736967 6.6816535,10.6210938 C6.92905057,10.8684908 7.05274725,11.1614566 7.05274725,11.5 C7.05274725,11.8385434 6.92905057,12.1315092 6.6816535,12.3789062 C6.43425643,12.6263033 6.14129061,12.75 5.80274725,12.75 C5.46420389,12.75 5.17123807,12.6263033 4.923841,12.3789062 C4.67644393,12.1315092 4.55274725,11.8385434 4.55274725,11.5 C4.55274725,11.1614566 4.66993358,10.8750012 4.90430975,10.640625 Z M11.1543098,10.640625 C11.4147277,10.380207 11.7142039,10.25 12.0527473,10.25 C12.3912906,10.25 12.6842564,10.3736967 12.9316535,10.6210938 C13.1790506,10.8684908 13.3027473,11.1614566 13.3027473,11.5 C13.3027473,11.8385434 13.1790506,12.1315092 12.9316535,12.3789062 C12.6842564,12.6263033 12.3912906,12.75 12.0527473,12.75 C11.7142039,12.75 11.4212381,12.6263033 11.173841,12.3789062 C10.9264439,12.1315092 10.8027473,11.8385434 10.8027473,11.5 C10.8027473,11.1614566 10.9199336,10.8750012 11.1543098,10.640625 Z M17.4043098,10.640625 C17.6647277,10.380207 17.9642039,10.25 18.3027473,10.25 C18.6412906,10.25 18.9342564,10.3736967 19.1816535,10.6210938 C19.4290506,10.8684908 19.5527473,11.1614566 19.5527473,11.5 C19.5527473,11.8385434 19.4290506,12.1315092 19.1816535,12.3789062 C18.9342564,12.6263033 18.6412906,12.75 18.3027473,12.75 C17.9642039,12.75 17.6712381,12.6263033 17.423841,12.3789062 C17.1764439,12.1315092 17.0527473,11.8385434 17.0527473,11.5 C17.0527473,11.1614566 17.1699336,10.8750012 17.4043098,10.640625 Z" id="Icon-/-Menu"></path>
                        </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-logout">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-1604.000000, -403.000000)"
                    fill="#555555" fill-rule="nonzero">
                    <g id="Icon-/-Log-out" transform="translate(1604.000000, 403.000000)">
                        <path
                            d="M8.5,9 C8.22385763,9 8,8.77614237 8,8.5 C8,8.22385763 8.22385763,8 8.5,8 L15.5,8 C15.7761424,8 16,8.22385763 16,8.5 C16,8.77614237 15.7761424,9 15.5,9 L8.5,9 Z"
                            id="Shape"></path>
                        <path
                            d="M14.7928932,8.5 L12.1464466,5.85355339 C11.9511845,5.65829124 11.9511845,5.34170876 12.1464466,5.14644661 C12.3417088,4.95118446 12.6582912,4.95118446 12.8535534,5.14644661 L15.8535534,8.14644661 C16.0488155,8.34170876 16.0488155,8.65829124 15.8535534,8.85355339 L12.8535534,11.8535534 C12.6582912,12.0488155 12.3417088,12.0488155 12.1464466,11.8535534 C11.9511845,11.6582912 11.9511845,11.3417088 12.1464466,11.1464466 L14.7928932,8.5 Z"
                            id="Shape"></path>
                        <path
                            d="M1,1.70710678 L1,11.2596876 L5,14.4596876 L5,5.70710678 L1,1.70710678 Z M1.70710678,1 L5.85355339,5.14644661 C5.94732158,5.2402148 6,5.36739176 6,5.5 L6,15.5 C6,15.9192531 5.51503415,16.1523397 5.18765248,15.8904344 L0.187652476,11.8904344 C0.0690448595,11.7955483 0,11.6518919 0,11.5 L0,0.5 C0,0.223857625 0.223857625,0 0.5,0 L8.5,0 C8.77614237,0 9,0.223857625 9,0.5 L9,4.5 C9,4.77614237 8.77614237,5 8.5,5 C8.22385763,5 8,4.77614237 8,4.5 L8,1 L1.70710678,1 Z"
                            id="Shape"></path>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-license">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-41.000000, -257.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Group-3" transform="translate(41.000000, 253.000000)">
                        <g id="Icon-/-License" transform="translate(0.000000, 4.000000)">
                            <path d="M7.5,14 C7.77614237,14 8,14.2238576 8,14.5 C8,14.7761424 7.77614237,15 7.5,15 L1.5,15 C0.671572875,15 1.66533454e-16,14.3284271 0,13.5 L0,1.5 C-8.32667268e-17,0.671572875 0.671572875,1.66533454e-16 1.5,0 L11.5,0 C12.3284271,0 13,0.671572875 13,1.5 L13,5.5 C13,5.77614237 12.7761424,6 12.5,6 C12.2238576,6 12,5.77614237 12,5.5 L12,1.5 C12,1.22385763 11.7761424,1 11.5,1 L1.5,1 C1.22385763,1 1,1.22385763 1,1.5 L1,13.5 C1,13.7761424 1.22385763,14 1.5,14 L7.5,14 Z" id="Shape"></path>
                            <path d="M12.5,12 C10.5670034,12 9,10.4329966 9,8.5 C9,6.56700338 10.5670034,5 12.5,5 C14.4329966,5 16,6.56700338 16,8.5 C16,10.4329966 14.4329966,12 12.5,12 Z M12.5,11 C13.8807119,11 15,9.88071187 15,8.5 C15,7.11928813 13.8807119,6 12.5,6 C11.1192881,6 10,7.11928813 10,8.5 C10,9.88071187 11.1192881,11 12.5,11 Z" id="Oval"></path>
                            <path d="M14,10.736 C14,10.4598576 14.2238576,10.236 14.5,10.236 C14.7761424,10.236 15,10.4598576 15,10.736 L15,15.5 C15,15.871691 14.6088437,16.1134389 14.2763932,15.9472136 L12.5,15.059017 L10.7236068,15.9472136 C10.3911563,16.1134389 10,15.871691 10,15.5 L10,10.736 C10,10.4598576 10.2238576,10.236 10.5,10.236 C10.7761424,10.236 11,10.4598576 11,10.736 L11,14.690983 L12.2763932,14.0527864 C12.4171569,13.9824045 12.5828431,13.9824045 12.7236068,14.0527864 L14,14.690983 L14,10.736 Z" id="Shape"></path>
                            <path d="M3.5,5 C3.22385763,5 3,4.77614237 3,4.5 C3,4.22385763 3.22385763,4 3.5,4 L8.5,4 C8.77614237,4 9,4.22385763 9,4.5 C9,4.77614237 8.77614237,5 8.5,5 L3.5,5 Z" id="Shape"></path>
                            <path d="M3.5,8 C3.22385763,8 3,7.77614237 3,7.5 C3,7.22385763 3.22385763,7 3.5,7 L6.5,7 C6.77614237,7 7,7.22385763 7,7.5 C7,7.77614237 6.77614237,8 6.5,8 L3.5,8 Z" id="Shape"></path>
                            <path d="M3.5,11 C3.22385763,11 3,10.7761424 3,10.5 C3,10.2238576 3.22385763,10 3.5,10 L6.5,10 C6.77614237,10 7,10.2238576 7,10.5 C7,10.7761424 6.77614237,11 6.5,11 L3.5,11 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-user-manual">
        <svg width="14px" height="16px" viewBox="0 0 14 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-42.000000, -313.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Group-3" transform="translate(41.000000, 253.000000)">
                        <g id="Icon-/-Manual-Instalation" transform="translate(1.000000, 60.000000)">
                            <path d="M3.5,12 C3.22385763,12 3,11.7761424 3,11.5 C3,11.2238576 3.22385763,11 3.5,11 L10.5,11 C10.7761424,11 11,11.2238576 11,11.5 C11,11.7761424 10.7761424,12 10.5,12 L3.5,12 Z" id="Shape"></path>
                            <path d="M3.5,9 C3.22385763,9 3,8.77614237 3,8.5 C3,8.22385763 3.22385763,8 3.5,8 L10.5,8 C10.7761424,8 11,8.22385763 11,8.5 C11,8.77614237 10.7761424,9 10.5,9 L3.5,9 Z" id="Shape"></path>
                            <path d="M3.5,6 C3.22385763,6 3,5.77614237 3,5.5 C3,5.22385763 3.22385763,5 3.5,5 L5.5,5 C5.77614237,5 6,5.22385763 6,5.5 C6,5.77614237 5.77614237,6 5.5,6 L3.5,6 Z" id="Shape"></path>
                            <path d="M8.5,0 C8.63260824,0 8.7597852,0.0526784202 8.85355339,0.146446609 L13.8535534,5.14644661 C13.9473216,5.2402148 14,5.36739176 14,5.5 L14,15.5 C14,15.7761424 13.7761424,16 13.5,16 L0.5,16 C0.223857625,16 0,15.7761424 0,15.5 L0,0.5 C0,0.223857625 0.223857625,0 0.5,0 L8.5,0 Z M8.29289322,1 L1,1 L1,15 L13,15 L13,5.70710678 L8.29289322,1 Z" id="Shape"></path>
                            <path d="M9,5 L13.5,5 C13.7761424,5 14,5.22385763 14,5.5 C14,5.77614237 13.7761424,6 13.5,6 L8.5,6 C8.22385763,6 8,5.77614237 8,5.5 L8,0.5 C8,0.223857625 8.22385763,0 8.5,0 C8.77614237,0 9,0.223857625 9,0.5 L9,5 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-admin-manual">
        <svg width="16px" height="16px" viewBox="0 0 26 26" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Documentation---Homepage" transform="translate(-567.000000, -385.000000)" fill="#555555">
                            <g id="Group-15" transform="translate(405.000000, 358.000000)">
                                    <g id="Group-14" transform="translate(135.000000, 0.000000)">
                                            <path d="M37.1875,27 L42.8125,27 L43,27.8125 L43.5625,30.75 C44.4791713,31.1250019 45.3333294,31.64583 46.125,32.3125 L49.0625,31.3125 L49.875,31.0625 L50.25,31.75 L52.25,35.25 L52.625,35.9375 L52.0625,36.5 L49.8125,38.4375 C49.9375006,39.1875038 50,39.7083319 50,40 C50,40.2916681 49.9375006,40.8124962 49.8125,41.5625 L52.0625,43.5 L52.625,44.0625 L52.25,44.75 L50.25,48.25 L49.875,48.9375 L49.0625,48.6875 L46.125,47.6875 C45.3333294,48.35417 44.4791713,48.8749981 43.5625,49.25 L43,52.1875 L42.8125,53 L37.1875,53 L37,52.1875 L36.4375,49.25 C35.5208287,48.8749981 34.6666706,48.35417 33.875,47.6875 L30.9375,48.6875 L30.125,48.9375 L29.75,48.25 L27.75,44.75 L27.375,44.0625 L27.9375,43.5 L30.1875,41.5625 C30.0624994,40.8124962 30,40.2916681 30,40 C30,39.7083319 30.0624994,39.1875038 30.1875,38.4375 L27.9375,36.5 L27.375,35.9375 L27.75,35.25 L29.75,31.75 L30.125,31.0625 L30.9375,31.3125 L33.875,32.3125 C34.6666706,31.64583 35.5208287,31.1250019 36.4375,30.75 L37,27.8125 L37.1875,27 Z M38.8125,29 L38.3125,31.625 L38.1875,32.1875 L37.625,32.375 C36.4999944,32.7500019 35.5000044,33.3333294 34.625,34.125 L34.125,34.5 L33.625,34.375 L31.0625,33.5 L29.875,35.5 L31.875,37.25 L32.375,37.625 L32.1875,38.25 C32.0624994,38.7916694 32,39.3749969 32,40 C32,40.6250031 32.0624994,41.2083306 32.1875,41.75 L32.375,42.375 L31.875,42.75 L29.875,44.5 L31.0625,46.5 L33.625,45.625 L34.125,45.5 L34.625,45.875 C35.5000044,46.6666706 36.4999944,47.2499981 37.625,47.625 L38.1875,47.8125 L38.3125,48.375 L38.8125,51 L41.1875,51 L41.6875,48.375 L41.8125,47.8125 L42.375,47.625 C43.5000056,47.2499981 44.4999956,46.6666706 45.375,45.875 L45.875,45.5 L46.375,45.625 L48.9375,46.5 L50.125,44.5 L48.125,42.75 L47.6875,42.375 L47.8125,41.75 C47.9375006,41.2083306 48,40.6250031 48,40 C48,39.3749969 47.9375006,38.7916694 47.8125,38.25 L47.625,37.625 L48.125,37.25 L50.125,35.5 L48.9375,33.5 L46.375,34.375 L45.875,34.5 L45.375,34.125 C44.4999956,33.3333294 43.5000056,32.7500019 42.375,32.375 L41.8125,32.1875 L41.6875,31.625 L41.1875,29 L38.8125,29 Z M36.4375,36.5 C37.437505,35.499995 38.6249931,35 40,35 C41.3750069,35 42.5520784,35.4895784 43.53125,36.46875 C44.5104216,37.4479216 45,38.6249931 45,40 C45,41.3750069 44.5104216,42.5520784 43.53125,43.53125 C42.5520784,44.5104216 41.3750069,45 40,45 C38.6249931,45 37.4479216,44.5104216 36.46875,43.53125 C35.4895784,42.5520784 35,41.3750069 35,40 C35,38.6249931 35.4791619,37.4583381 36.4375,36.5 Z M42.125,37.875 C41.5416637,37.2916637 40.8333375,37 40,37 C39.1666625,37 38.4583363,37.2916637 37.875,37.875 C37.2916637,38.4583363 37,39.1666625 37,40 C37,40.8333375 37.2916637,41.5416637 37.875,42.125 C38.4583363,42.7083363 39.1666625,43 40,43 C40.8333375,43 41.5416637,42.7083363 42.125,42.125 C42.7083363,41.5416637 43,40.8333375 43,40 C43,39.1666625 42.7083363,38.4583363 42.125,37.875 Z" id="Icon-/-Settings"></path>
                                    </g>
                            </g>
                    </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-install-manual">
        <svg width="15px" height="15px" viewBox="0 0 15 15" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-41.000000, -426.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Group-3" transform="translate(41.000000, 253.000000)">
                        <g id="Icon-/-Explotation" transform="translate(0.000000, 173.000000)">
                            <path d="M10.1464466,7.14644661 C10.3417088,6.95118446 10.6582912,6.95118446 10.8535534,7.14644661 C11.0488155,7.34170876 11.0488155,7.65829124 10.8535534,7.85355339 L7.85355339,10.8535534 C7.65829124,11.0488155 7.34170876,11.0488155 7.14644661,10.8535534 L4.14644661,7.85355339 C3.95118446,7.65829124 3.95118446,7.34170876 4.14644661,7.14644661 C4.34170876,6.95118446 4.65829124,6.95118446 4.85355339,7.14644661 L7.5,9.79289322 L10.1464466,7.14644661 Z" id="Shape"></path>
                            <path d="M8,10.5 C8,10.7761424 7.77614237,11 7.5,11 C7.22385763,11 7,10.7761424 7,10.5 L7,0.5 C7,0.223857625 7.22385763,0 7.5,0 C7.77614237,0 8,0.223857625 8,0.5 L8,10.5 Z" id="Shape"></path>
                            <path d="M13.0524786,6 L10.5,6 C10.2238576,6 10,5.77614237 10,5.5 C10,5.22385763 10.2238576,5 10.5,5 L13.5,5 C13.7547746,5 13.9688067,5.1915679 13.9969419,5.44478424 L14.9969419,14.4447842 C15.0298511,14.7409672 14.7980056,15 14.5,15 L0.5,15 C0.201994351,15 -0.0298510859,14.7409672 0.00305813266,14.4447842 L1.00305813,5.44478424 C1.03119328,5.1915679 1.24522539,5 1.5,5 L4.5,5 C4.77614237,5 5,5.22385763 5,5.5 C5,5.77614237 4.77614237,6 4.5,6 L1.9475214,6 L1.05863251,14 L13.9413675,14 L13.0524786,6 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-settings-manual">
        <svg width="16px" height="14px" viewBox="0 0 16 14" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-41.000000, -482.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Group-3" transform="translate(41.000000, 253.000000)">
                        <g id="Icon-/-Integration" transform="translate(0.000000, 229.000000)">
                            <path d="M16,7 C16,8.29164249 15.1781958,9.4134174 14,9.82924315 L14,13.5 C14,13.7761424 13.7761424,14 13.5,14 L10.45,14 C10.2122609,14 10.0073963,13.8325986 9.96002598,13.5996266 C9.7720288,12.675037 8.95556219,12 8,12 C7.04443781,12 6.2279712,12.675037 6.03997402,13.5996266 C5.99260372,13.8325986 5.78773913,14 5.55,14 L2.5,14 C2.22385763,14 2,13.7761424 2,13.5 L2,9.82924315 C0.821804188,9.4134174 0,8.29164249 0,7 C0,5.70835751 0.821804188,4.5865826 2,4.17075685 L2,0.5 C2,0.223857625 2.22385763,0 2.5,0 L5.55,0 C5.78773913,0 5.99260372,0.167401386 6.03997402,0.400373381 C6.2279712,1.32496298 7.04443781,2 8,2 C8.95556219,2 9.7720288,1.32496298 9.96002598,0.400373381 C10.0073963,0.167401386 10.2122609,0 10.45,0 L13.5,0 C13.7761424,0 14,0.223857625 14,0.5 L14,4.17075685 C15.1781958,4.5865826 16,5.70835751 16,7 Z M13,9.45 C13,9.21226087 13.1674014,9.00739628 13.4003734,8.96002598 C14.324963,8.7720288 15,7.95556219 15,7 C15,6.04443781 14.324963,5.2279712 13.4003734,5.03997402 C13.1674014,4.99260372 13,4.78773913 13,4.55 L13,1 L10.8292432,1 C10.4134174,2.17819581 9.29164249,3 8,3 C6.70835751,3 5.5865826,2.17819581 5.17075685,1 L3,1 L3,4.55 C3,4.78773913 2.83259861,4.99260372 2.59962662,5.03997402 C1.67503702,5.2279712 1,6.04443781 1,7 C1,7.95556219 1.67503702,8.7720288 2.59962662,8.96002598 C2.83259861,9.00739628 3,9.21226087 3,9.45 L3,13 L5.17075685,13 C5.5865826,11.8218042 6.70835751,11 8,11 C9.29164249,11 10.4134174,11.8218042 10.8292432,13 L13,13 L13,9.45 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-update-manual">
        <svg width="15px" height="16px" viewBox="0 0 15 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Inner-Page" transform="translate(-41.000000, -537.000000)" fill="#555555" fill-rule="nonzero">
                    <g id="Group-3" transform="translate(41.000000, 253.000000)">
                        <g id="Icon-/-Update" transform="translate(0.000000, 284.000000)">
                            <path d="M1,7.5 C1,7.77614237 0.776142375,8 0.5,8 C0.223857625,8 0,7.77614237 0,7.5 C0,3.35785763 3.35785763,0 7.5,0 C10.2403251,0 12.6454229,1.65614711 13.9477816,4.27753284 C14.0706468,4.52483579 13.9697701,4.82491638 13.7224672,4.9477816 C13.4751642,5.07064682 13.1750836,4.96977011 13.0522184,4.72246716 C11.9112025,2.42583191 9.84057407,1 7.5,1 C3.91014237,1 1,3.91014237 1,7.5 Z" id="Shape"></path>
                            <path d="M13,4 L13,0.5 C13,0.223857625 13.2238576,0 13.5,0 C13.7761424,0 14,0.223857625 14,0.5 L14,4.5 C14,4.77614237 13.7761424,5 13.5,5 L9.5,5 C9.22385763,5 9,4.77614237 9,4.5 C9,4.22385763 9.22385763,4 9.5,4 L13,4 Z" id="Shape"></path>
                            <path d="M14,8.5 C14,8.22385763 14.2238576,8 14.5,8 C14.7761424,8 15,8.22385763 15,8.5 C15,12.6421424 11.6421424,16 7.5,16 C4.75967493,16 2.35457706,14.3438529 1.0522184,11.7224672 C0.929353178,11.4751642 1.03022989,11.1750836 1.27753284,11.0522184 C1.52483579,10.9293532 1.82491638,11.0302299 1.9477816,11.2775328 C3.08879751,13.5741681 5.15942593,15 7.5,15 C11.0898576,15 14,12.0898576 14,8.5 Z" id="Shape"></path>
                            <path d="M2,12 L2,15.5 C2,15.7761424 1.77614237,16 1.5,16 C1.22385763,16 1,15.7761424 1,15.5 L1,11.5 C1,11.2238576 1.22385763,11 1.5,11 L5.5,11 C5.77614237,11 6,11.2238576 6,11.5 C6,11.7761424 5.77614237,12 5.5,12 L2,12 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-sidenav-plus">
        <svg class="lg__sidenav-plus" width="10px" height="10px" viewBox="0 0 14 15" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1627.000000, -294.000000)" fill="#555555">
                    <g id="Group" transform="translate(1622.000000, 291.000000)">
                        <polygon id="Icon-/-Plus" points="11.4277473 3.625 12.6777473 3.625 12.6777473 9.875 18.9277473 9.875 18.9277473 11.125 12.6777473 11.125 12.6777473 17.375 11.4277473 17.375 11.4277473 11.125 5.17774725 11.125 5.17774725 9.875 11.4277473 9.875"></polygon>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-sidenav-minus">
        <svg class="lg__sidenav-minus" width="10px" height="2px" viewBox="0 0 10 2" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Tags" transform="translate(-718.000000, -364.000000)" fill="#555555">
                    <g id="Group-2" transform="translate(660.000000, 120.000000)">
                        <g id="Stacked-Group" transform="translate(0.000000, 69.000000)">
                            <g transform="translate(40.000000, 147.000000)" id="Group-3">
                                <g id="Group">
                                    <polygon id="Icon-/-Minus" points="18.1875 28.3125 27.8125 28.3125 27.8125 29.1875 18.1875 29.1875"></polygon>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-actions-edit">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1254.000000, -294.000000)" fill="#1ABC9C" fill-rule="nonzero">
                    <g id="Group-19" transform="translate(1255.000000, 291.000000)">
                        <g id="Icon-/-Edit" transform="translate(0.000000, 3.000000)">
                            <path d="M0,16 C-0.276142375,16 -0.5,15.7761424 -0.5,15.5 C-0.5,15.2238576 -0.276142375,15 0,15 L14,15 C14.2761424,15 14.5,15.2238576 14.5,15.5 C14.5,15.7761424 14.2761424,16 14,16 L0,16 Z" id="Shape"></path>
                            <path d="M1.45148201,9.25562477 L0.687184271,12.3128157 L3.74437523,11.548518 L11.7928932,3.5 L9.5,1.20710678 L1.45148201,9.25562477 Z M9.85355339,0.146446609 L12.8535534,3.14644661 C13.0488155,3.34170876 13.0488155,3.65829124 12.8535534,3.85355339 L4.35355339,12.3535534 C4.28947398,12.4176328 4.20918404,12.4630922 4.12126781,12.4850713 L0.121267813,13.4850713 C-0.244922421,13.5766188 -0.576618808,13.2449224 -0.48507125,12.8787322 L0.51492875,8.87873219 C0.536907807,8.79081596 0.582367198,8.71052602 0.646446609,8.64644661 L9.14644661,0.146446609 C9.34170876,-0.0488155365 9.65829124,-0.0488155365 9.85355339,0.146446609 Z" id="Shape"></path>
                            <path d="M7.14644661,2.85355339 C6.95118446,2.65829124 6.95118446,2.34170876 7.14644661,2.14644661 C7.34170876,1.95118446 7.65829124,1.95118446 7.85355339,2.14644661 L10.8535534,5.14644661 C11.0488155,5.34170876 11.0488155,5.65829124 10.8535534,5.85355339 C10.6582912,6.04881554 10.3417088,6.04881554 10.1464466,5.85355339 L7.14644661,2.85355339 Z" id="Shape"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-actions-unpublish">
        <svg width="18px" height="13px" viewBox="0 0 18 13" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1373.000000, -296.000000)" fill="#1ABC9C">
                    <g id="Group-13" transform="translate(1370.000000, 291.000000)">
                        <polygon id="Icon-/-Check" points="19.7089973 5.40625 20.6464973 6.34375 9.39649725 17.59375 8.92774725 17.984375 8.45899725 17.59375 3.45899725 12.59375 4.39649725 11.65625 8.92774725 16.2265625"></polygon>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-actions-tag">
        <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1502.000000, -295.000000)" fill="#1ABC9C" fill-rule="nonzero">
                    <g id="Group-12" transform="translate(1502.000000, 291.000000)">
                        <g id="Icon-/-Tag" transform="translate(8.000000, 12.000000) scale(-1, 1) translate(-8.000000, -12.000000) translate(0.000000, 4.000000)">
                            <path d="M1,1 L1,6.79289322 L9,14.7928932 L14.7928932,9 L6.79289322,1 L1,1 Z M0.5,0 L7,0 C7.13260824,0 7.2597852,0.0526784202 7.35355339,0.146446609 L15.8535534,8.64644661 C16.0488155,8.84170876 16.0488155,9.15829124 15.8535534,9.35355339 L9.35355339,15.8535534 C9.15829124,16.0488155 8.84170876,16.0488155 8.64644661,15.8535534 L0.146446609,7.35355339 C0.0526784202,7.2597852 0,7.13260824 0,7 L0,0.5 C0,0.223857625 0.223857625,0 0.5,0 Z" id="Shape"></path>
                            <circle id="Oval" cx="4" cy="4" r="1"></circle>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="svg-actions-addcontent">
        <svg width="14px" height="15px" viewBox="0 0 14 15" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g id="Revised" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="Documentation---Main-Page" transform="translate(-1627.000000, -294.000000)" fill="#1ABC9C">
                    <g id="Group" transform="translate(1622.000000, 291.000000)">
                        <polygon id="Icon-/-Plus" points="11.4277473 3.625 12.6777473 3.625 12.6777473 9.875 18.9277473 9.875 18.9277473 11.125 12.6777473 11.125 12.6777473 17.375 11.4277473 17.375 11.4277473 11.125 5.17774725 11.125 5.17774725 9.875 11.4277473 9.875"></polygon>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
</xsl:stylesheet>