<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		exclude-result-prefixes="ametys resolver">
		
    <!-- Used by common -->         
    <xsl:import href="plugin:web://pages/services/filtered-contents/list_3.3.xsl"/>     
    
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('css/services/carousel.css')}" media="screen, print, handheld"/>
    </xsl:template>  
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div  
            data-infinite="false" 
            data-center-mode="false" 
            data-center-padding="60px" 
            data-slides-show="3" 
            data-arrows-classes="u-arrow-v1 g-absolute-centered--y g-width-35 g-height-40 g-font-size-18 g-color-gray g-bg-white"
            data-arrow-left-classes="fa fa-angle-left g-left-0" 
            data-arrow-right-classes="fa fa-angle-right g-right-0">
            <xsl:call-template name="get-classes"/>
            <xsl:apply-templates select="/contents/content"/>
        </div>
    </xsl:template>
    
    <xsl:template name="get-classes">
        <xsl:attribute name="class">
            <xsl:text>js-carousel</xsl:text>
            <xsl:choose>
                <xsl:when test="count(/contents/content) = 1"><xsl:text> size-1</xsl:text></xsl:when>
                <xsl:when test="count(/contents/content) = 2"><xsl:text> size-2</xsl:text></xsl:when>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="content">
        <div class="js-slide g-px-10 g-py-10">
            <xsl:variable name="href"><xsl:call-template name="get-read-more"/></xsl:variable>
            <a href="{$href}" class="read-more" title="En savoir plus">
                <xsl:apply-templates select="html/body/div[contains(@class, 'ametys-cms-content')]/node()" mode="move-hierarchy">
                    <xsl:with-param name="level">2</xsl:with-param>
                </xsl:apply-templates>
                
                <xsl:call-template name="content-illustration"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="content-illustration">
	    <xsl:if test="ametys:hasValue(@id, 'illustration/image')">
            <xsl:variable name="imageAltText" select="ametys:contentAttribute(@id, 'illustration/alt-text')"/>
	        <xsl:variable name="image" select="ametys:contentAttribute(@id, 'illustration/image')"/>
	        <img src="{resolver:resolveBoundedImage($image/@type, $image/@uri, 400, 400)}" alt="{$imageAltText}"/>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="get-read-more">
        <xsl:value-of select="html/body/div[contains(@class, 'ametys-cms-content')]//*[@class='content-read-more']//a[@class='url']/@href"/>
    </xsl:template>
		
    <xsl:template match="p[@class='content-read-more']" mode="move-hierarchy"/>
    
    <xsl:template match="div[contains(@class, 'content-illustration')]" mode="move-hierarchy"/>
</xsl:stylesheet>		
