<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:math="java.lang.Math"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                            exclude-result-prefixes="ametys resolver math">

    <xsl:import href="plugin:multimedia://stylesheets/content/photosGallery/photosGallery-main.xsl"/>
    <xsl:import href="skin://stylesheets/content/photosGallery/photosGallery.xsl"/>
	
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-content-head-js">
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/masonry/dist/masonry.pkgd.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/imagesloaded/imagesloaded.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/fancybox/jquery.fancybox.min.js')}"></script>
        
        <!-- JS unify25 -->
        <script  src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.popup.js')}"></script>
        
        <script>
          $(document).on('ready', function () {
            
            // initialization of masonry
            $('#masonry-grid-<xsl:value-of select="$uniqueId"/>').imagesLoaded().then(function () {
              $('#masonry-grid-<xsl:value-of select="$uniqueId"/>').masonry({
                columnWidth: '.masonry-grid-sizer',
                itemSelector: '.masonry-grid-item',
                percentPosition: true
              });
            });
        
            // initialization of popups
            $.HSCore.components.HSPopup.init('.js-fancybox', {
              transitionEffect: false
            });
          });
        </script>
    </xsl:template>
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" type="text/css" href="{ametys:skinURL('css/content/photosgallery.css')}"/>
         <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('unify25', 'assets/vendor/fancybox/jquery.fancybox.min.css')}"/>
    </xsl:template>     
    
    <xsl:template name="photos">
        <xsl:if test="metadata/photos/entry/image">
            <div class="masonry-grid" id="masonry-grid-{$uniqueId}">
                <div class="masonry-grid-sizer g-width-33_3x--sm"></div>
                <xsl:for-each select="metadata/photos/entry[image]">
                    <xsl:call-template name="photo"/>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="photo">
        <div class="masonry-grid-item g-width-33_3x--sm">
            <a class="js-fancybox" data-fancybox="lightbox-gallery-{$uniqueId}" data-src="{resolver:resolve(image/@type, image/@path)}">
                <xsl:attribute name="data-caption">
                    <xsl:choose>
                        <xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:choose>
                        <xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                
                <xsl:if test="$rendering-context = 'back'">
                    <xsl:attribute name="internal">internal</xsl:attribute>
                </xsl:if>
                
                <img src="{resolver:resolveBoundedImage(image/@type, image/@path, 400, 400)}" alt="{alt-text}"/>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
