<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
    
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    <xsl:import href="plugin:web://stylesheets/helper/fastsearch.xsl"/>
    
	<!-- + | HEAD + -->
	<xsl:template name="head">
		<head>
            <title><xsl:call-template name="get-title" /></title>
            
            <xsl:call-template name="meta" />
            <xsl:call-template name="og-meta" />
                
			<xsl:call-template name="common-css"/>
            <xsl:call-template name="additionnal-css" />
            
            <xsl:call-template name="common-script"/>
            <xsl:call-template name="additionnal-script" />
		</head>
	</xsl:template>
    
    <xsl:template name="head-meta-top">
        <meta http-equiv="x-ua-compatible" content="ie=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
    </xsl:template>
    
    <xsl:template name="get-title">
        <xsl:choose>
            <xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
            <xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
        </xsl:choose>
        <i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <!-- + 
         | META
         + -->
    <xsl:template name="meta">
        <meta name="author" content="Ametys V4" />
        <meta name="copyright" content="Ametys V4" />
        <meta name="language" content="{$lang}" />
        <meta name="revisit-after" content="15 days" />
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.subject']">
            <meta name="subject" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.subject']/@content}"/>
        </xsl:if>
        
        <xsl:if test="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[@name = 'DC.description']">
            <meta name="description" content="{/cms/page/pageContents/zone/zoneItem/html/head/meta[@name = 'DC.description']/@content}"/>
        </xsl:if>
        
        <!-- Copy Dublin Core metadata. -->
        <xsl:copy-of select="/cms/page/pageContents/zone[@name = 'default']/zoneItem/html/head/meta[starts-with(@name, 'DC.')]"/>
    </xsl:template>
    
    <!-- + 
         | OPEN GRAPH META
         + -->
    <xsl:template name="og-meta">
        <xsl:comment>
            <xsl:for-each select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type = 'CONTENT'][1]/html/head">
                    <meta property="og:title" content="{meta[@name = 'DC.title']/@content}" />
                    <xsl:if test="meta[@name = 'DC.description']">
                        <meta property="og:description" content="{meta[@name = 'DC.description']/@content}" />
                    </xsl:if>
                    <xsl:if test="meta[@name = 'DC.type']">
                        <meta property="og:type" content="{meta[@name = 'DC.type']/@content}" />
                    </xsl:if>
            </xsl:for-each>
        </xsl:comment>
    </xsl:template>

	<xsl:template name="common-css">
      <!-- Prettify -->
      <link rel="stylesheet" type="text/css" href="{ametys:skinURL('prettify/prettify.css')}"/>
      
      <!-- CSS unify25 -->
      <!-- <link rel="stylesheet" href="{ametys:skinURL('css/unify25-admin.css')}"/> -->
      
      <!-- CSS Customization -->
      <link rel="stylesheet" href="{ametys:skinURL('scss/custom.css')}"/>
      
      <link rel="stylesheet" href="{ametys:skinURL('css/print.css')}" media="print" data-donotminimize="true"/>
      
      <xsl:call-template name="head-css-fonts"/>
      
      <xsl:call-template name="head-css-fancybox"/>
	</xsl:template>
	
    <xsl:template name="head-css-fonts">
      <!-- Font -->
      <link rel="stylesheet" href="{ametys:skinURL('fonts/DocIcon.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-script">
        <!-- Prettify -->
        <script src="{ametys:skinURL('prettify/prettify.js')}" type="text/javascript"></script>
        
        <!-- JS Global Compulsory -->
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/jquery/jquery.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/jquery-migrate/jquery-migrate.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/popper.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/bootstrap/bootstrap.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/bootstrap-select/js/bootstrap-select.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/cookiejs/jquery.cookie.js')}"></script>
    
        <!-- JS Implementing Plugins -->
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/hs-megamenu/src/hs.megamenu.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/dzsparallaxer/dzsparallaxer.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/dzsparallaxer/dzsscroller/scroller.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/dzsparallaxer/advancedscroller/plugin.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/chosen/chosen.jquery.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/image-select/src/ImageSelect.jquery.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/masonry/dist/masonry.pkgd.min.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/slick-carousel/slick/slick.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/custombox/custombox.min.js')}"></script>
    
        <!-- JS unify25 -->
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/hs.core.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.side-nav.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.header.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/helpers/hs.hamburgers.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.scroll-nav.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.sticky-block.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/helpers/hs.height-calc.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.carousel.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.go-to.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.dropdown.js')}"></script>
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.modal-window.js')}"></script>
    
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="enableSimpleMode">true</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
                
        <!-- JS Custom -->
        <script src="{ametys:pluginResourceURL('unify25', 'assets/js/jquery.stickyscroll.js')}"></script>
        <script src="{ametys:skinURL('js/custom.js')}"></script>
        
        <xsl:call-template name="head-fastsearch-script"/>
    
        <xsl:call-template name="js-plugin-init" />
        
        <xsl:call-template name="head-js-fancybox"/>
    </xsl:template>
    
    <xsl:template name="js-plugin-init">
        <!-- JS Plugins Init. -->
        <script>
            $(document).on('ready', function () {
    
            // initialization of popups
            $.HSCore.components.HSModalWindow.init('[data-modal-target]');
    
            // initialization of HSDropdown component
            $.HSCore.components.HSDropdown.init($('[data-dropdown-target]'), {
            afterOpen: function () {
            $(this).find('input[type="search"]').focus();
            }
            });
    
            // initialization of go to
            // $.HSCore.components.HSGoTo.init('.js-go-to');
    
            // initialization of carousel
            $.HSCore.components.HSCarousel.init('.js-carousel');
    
            $('#carousel1').slick('setOption', 'responsive', [
				{
				breakpoint: 2000,
				settings: {
					slidesToShow: 3
				}
				}, {
					breakpoint: 992,
					settings: {
						centerMode: true,
						slidesToShow: 3
					}
				}, {
					breakpoint: 768,
					settings: {
						centerMode: true,
						slidesToShow: 2,
						dots: true,
						infinite: true
					}
				}, {
					breakpoint: 576,
					settings: {
						centerMode: true,
						slidesToShow: 1,
						dots: true,
						infinite: true
					}
				}, {
					breakpoint: 446,
					settings: {
						centerMode: true,
						slidesToShow: 1,
						dots: true,
						infinite: true
					}
				}
			], true);
    
            // Header
            $.HSCore.components.HSHeader.init($('#js-header'));
            $.HSCore.helpers.HSHamburgers.init('.hamburger');
    
            // initialization of HSMegaMenu plugin
            $('.js-mega-menu').HSMegaMenu({
                event: 'hover',
                pageContainer: $('.container'),
                breakpoint: 991
            });
    
            // initialization of go to
			$.HSCore.helpers.HSHeightCalc.init();

			 // initialization of sidebar navigation component
			 $.HSCore.components.HSSideNav.init('.js-side-nav');
    
            // initialization of custom select
            $('.js-select').selectpicker();
            });
    
            $(window).on('load', function () {
    			// initialization of HSScrollNav
    			$.HSCore.components.HSScrollNav.init($('#js-scroll-nav'), {
    				duration: 700,
    				easing: 'easeOutExpo',
    				over: $('.u-secondary-navigation')
    			});
    
    			// initialization of sticky blocks
    			$.HSCore.components.HSStickyBlock.init('.js-sticky-block');
    		});
        </script>
    </xsl:template>
    
    <xsl:template name="favico">
        <xsl:choose>
            <xsl:when test="ametys:skinResources('img/favicon.ico')">
                <link rel="icon" type="image/x-icon" href="{ametys:skinURL('img/favicon.ico')}" />
                <link rel="shortcut icon" type="image/x-icon" href="{ametys:skinURL('img/favicon.ico')}" />
            </xsl:when>
            <xsl:otherwise>
                <link rel="icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$uri-prefix}/favicon.ico" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
    <xsl:template name="additionnal-css"/>
    
    <xsl:template name="additionnal-script"/>
    
    <xsl:template name="head-js-pirobox"/>
    <xsl:template name="head-css-pirobox"/>
    
    <xsl:template name="head-css-fancybox">
        <link rel="stylesheet" type="text/css" href="{ametys:pluginResourceURL('unify25', 'assets/vendor/fancybox/jquery.fancybox.min.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-fancybox">
        <script src="{ametys:pluginResourceURL('unify25', 'assets/vendor/fancybox/jquery.fancybox.min.js')}"></script>
        <script  src="{ametys:pluginResourceURL('unify25', 'assets/js/components/hs.popup.js')}"></script>
        
        <script>
          $(document).on('ready', function () {
            // initialization of popups
            $.HSCore.components.HSPopup.init('.js-fancybox', {
              transitionEffect: false
            });
          });
        </script>
    </xsl:template>
</xsl:stylesheet>
