<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<xsl:template name="sidebar-dropdown">
        <xsl:param name="pages"/>
        
        <xsl:variable name="highlight-restricted"><xsl:if test="$conf-layout-highlight-restricted-page = 'true'"> highlight-restricted</xsl:if></xsl:variable>
        
        <div class="theme-sidebar__dropdown hide-restricted{$highlight-restricted}">
            <div class="form-group u-select--v3 g-pos-rel g-brd-gray-light-v7 rounded-0 g-mb-35--lg g-mb-20">
                <select onchange="window.location.href = this.value" class="js-select u-select--v3-select u-sibling w-100 theme-sidebar-select" required="required" title="skin.{$skin}:SKIN_SPACES_DROP_DOWN" i18n:attr="title" style="display: none;">
                    <xsl:for-each select="$pages">
                        <option value="{resolver:resolve('page', @sitemap:id)}" 
                                data-restricted="{@sitemap:restricted}"
                                data-content='&lt;span class="d-flex align-items-center w-100">&lt;span>{@sitemap:title}&lt;/span>&lt;/span>'>
                                <xsl:if test="@sitemap:restricted"><xsl:attribute name="class">restricted</xsl:attribute></xsl:if>
                                <xsl:if test="@sitemap:in-path"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                <xsl:value-of select="@sitemap:title"/>
                        </option>
                    </xsl:for-each>
                </select>

                <div class="d-flex align-items-center g-absolute-centered--y g-right-0 g-color-gray-light-v6 g-color-lightblue-v9--sibling-opened g-mr-15">
                    <i class="hs-admin-angle-down"></i>
                </div>
            </div>
            <script type="text/javascript">
                $j(document).ready(function() {
                    var _getAmetysUserCb = function(user)
                    {
                        if (user)
                        {
                            $j('.theme-sidebar__dropdown').removeClass('hide-restricted');
                        }
                        else
                        {
                            $j('.theme-sidebar__dropdown').addClass('hide-restricted');
                        }
                    }
                    
                    getAmetysUser(_getAmetysUserCb);
                });
            </script>
        </div>
	</xsl:template>
    
    <xsl:template name="side-nav-menu">
        <xsl:param name="rootPage"/>
        
        <xsl:variable name="highlight-restricted"><xsl:if test="$conf-layout-highlight-restricted-page = 'true'"> highlight-restricted</xsl:if></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$conf-layout-right-navigation != 'true'">
                <div class="u-sidebar-navigation-v1-menu u-side-nav--top-level-menu mb-0 theme-sidebar hide-restricted{$highlight-restricted}">
                    <xsl:call-template name="side-nav-submenu">
                        <xsl:with-param name="idsubmenu" select="concat('submenu-', generate-id())"/>
                        <xsl:with-param name="rootPage" select="$rootPage"/>
                    </xsl:call-template>
                </div> 
                <script type="text/javascript">
                    $j(document).ready(function() {
                        var _getAmetysUserCb = function(user)
                        {
                            if (user)
                            {
                                $j('.u-sidebar-navigation-v1-menu').removeClass('hide-restricted');
                            }
                            else
                            {
                                $j('.u-sidebar-navigation-v1-menu').addClass('hide-restricted');
                            }
                        }
                        getAmetysUser(_getAmetysUserCb);
                    });
                </script>
            </xsl:when>
            <xsl:otherwise>
                <ul id="sideNavMenu" class="u-sidebar-navigation-v1-menu u-side-nav--top-level-menu mb-0 theme-sidebar hide-restricted{$highlight-restricted}">
                    <xsl:if test="$conf-layout-right-navigation != 'true'">
                        <xsl:attribute name="class">u-sidebar-navigation-v1-menu u-side-nav--full u-side-nav--top-level-menu mb-0 theme-sidebar<xsl:value-of select="$highlight-restricted"/></xsl:attribute>
                    </xsl:if>
                    <xsl:for-each select="$rootPage/page[@sitemap:path != 'index' and not(@sitemap:invisible)]">
                        <xsl:variable name="active"><xsl:if test="@sitemap:in-path"> active</xsl:if></xsl:variable>
                        <xsl:variable name="restricted"><xsl:if test="@sitemap:restricted"> restricted</xsl:if></xsl:variable>
                        <li class="u-sidebar-navigation-v1-menu-item u-side-nav--has-sub-menu u-side-nav--top-level-menu-item{$active}{$restricted}">
                            <a class="media u-side-nav--top-level-menu-link u-side-nav--hide-on-hidden g-px-15 g-py-12 link-desktop"
                                 href="{resolver:resolve('page', @sitemap:id)}">
                                <xsl:call-template name="side-nav-menu-icon"/>
                                <span class="media-body align-self-center"><xsl:value-of select="@sitemap:title"/></span>
                            </a>
                            <!-- Mobile -->
                            <a class="media u-side-nav--top-level-menu-link u-side-nav--hide-on-hidden g-px-15 g-py-12 link-mobile"
                                href="{resolver:resolve('page', @sitemap:id)}"
                                data-hssm-target="#submenu-{generate-id()}">
                                <xsl:call-template name="side-nav-menu-icon"/>
                                <span class="media-body align-self-center"><xsl:value-of select="@sitemap:title"/></span>
                            </a>
                            <xsl:call-template name="side-nav-submenu">
                                <xsl:with-param name="idsubmenu" select="concat('submenu-', generate-id())"/>
                                <xsl:with-param name="rootPage" select="."/>
                            </xsl:call-template>
                        </li>
                    </xsl:for-each>
                </ul>
                <script type="text/javascript">
                    $j(document).ready(function() {
                        var _getAmetysUserCb = function(user)
                        {
                            if (user)
                            {
                                $j('#sideNavMenu').removeClass('hide-restricted');
                            }
                            else
                            {
                                $j('#sideNavMenu').addClass('hide-restricted');
                            }
                        }
                        getAmetysUser(_getAmetysUserCb);
                    });
                </script>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="side-nav-menu-icon">
    	<xsl:variable name="additional-class">
            <xsl:call-template name="side-nav-menu-icon-additional-class"/>
    	</xsl:variable>
        
        <span class="d-flex align-self-center g-pos-rel g-font-size-16 g-mr-18 g-font-weight-400 {$additional-class}">
        </span>
    </xsl:template>
    
    <xsl:template name="side-nav-menu-icon-additional-class"/>
    
    <xsl:template name="side-nav-submenu">
        <xsl:param name="idsubmenu"/>
        <xsl:param name="rootPage"/>
        
        <xsl:if test="$rootPage/page[@sitemap:path != 'index']">
            <ul id="{$idsubmenu}" class="lg__sidenav u-sidebar-navigation-v1-menu u-side-nav--second-level-menu mb-0">
                <xsl:apply-templates select="$rootPage/page[@sitemap:path != 'index' and not(@sitemap:invisible)]" mode="lg-submenu"/>
            </ul>    
        </xsl:if>           
    </xsl:template>
    
    <xsl:template match="page" mode="lg-submenu">
        <xsl:variable name="restricted"><xsl:if test="@sitemap:restricted"> restricted</xsl:if></xsl:variable>
        
        <li class="lg__sidenav__item{$restricted}">
            <xsl:if test="not(page)"><xsl:attribute name="class">lg__sidenav__item lg__sidenav__item__leaf<xsl:value-of select="$restricted"/></xsl:attribute></xsl:if>
            <xsl:choose>
                <xsl:when test="page[not(@sitemap:invisible)]">
                    <div class="d-flex align-items-center lg__sidenav__item__link_wrap">
                        <a href="#!" class="lg__sidenav__item__link lg__sidenav__item__link_icon">
                            <xsl:if test="page[@sitemap:in-path]"><xsl:attribute name="class">lg__sidenav__item__link lg__sidenav__item__link_icon active</xsl:attribute></xsl:if>
                            <xsl:call-template name="svg-sidenav-plus"/>
                            <xsl:call-template name="svg-sidenav-minus"/>
                        </a>
                        <a href="{resolver:resolve('page', @sitemap:id)}" class="lg__sidenav__item__link_txt">
                            <xsl:if test="@sitemap:in-path">
                                <xsl:attribute name="class">lg__sidenav__item__link_txt active</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="@sitemap:title"/>
                        </a>
                    </div>
                    <ul class="lg__sidenav lg__sidenav-sub" data-submenu="lg-submenu">
                        <xsl:if test="page[@sitemap:in-path]">
                            <xsl:attribute name="style">display: block;</xsl:attribute>
                        </xsl:if>
                        <xsl:apply-templates select="page[not(@sitemap:invisible)]" mode="lg-submenu"/>
                    </ul>
                </xsl:when>
                <xsl:otherwise>
                    <a href="{resolver:resolve('page', @sitemap:id)}" class="lg__sidenav__item__link_txt">
                        <xsl:if test="@sitemap:in-path">
                            <xsl:attribute name="class">lg__sidenav__item__link_txt active</xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="@sitemap:title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template name="side-nav-menu-inner">
        <xsl:param name="rootPage"/>
        
        <xsl:if test="$rootPage">
            <div class="second-navigation col-xl-3 g-mb-0--xl g-mb-30 lg-hidden">
                <!-- r-side__inner -->
                <div class="r-side__inner g-pa-40">
                    <h3 class="color-grey g-font-primary-light g-font-size-20 g-mb-30">
                        <xsl:value-of select="$rootPage/@sitemap:title"/>
                    </h3>    
                    <xsl:variable name="highlight-restricted"><xsl:if test="$conf-layout-highlight-restricted-page = 'true'"> highlight-restricted</xsl:if></xsl:variable>
                    <ul class="lg__sidenav hide-restricted{$highlight-restricted}">
                        <xsl:apply-templates select="$rootPage/page" mode="lg-submenu"/>        
                    </ul>
                    <script type="text/javascript">
                        $j(document).ready(function() {
                            var _getAmetysUserCb = function(user)
                            {
                                if (user)
                                {
                                    $j('.lg__sidenav').removeClass('hide-restricted');
                                }
                                else
                                {
                                    $j('.lg__sidenav').addClass('hide-restricted');
                                }
                            }
                            getAmetysUser(_getAmetysUserCb);
                        });
                    </script>
                </div>
            </div>
        </xsl:if>
   </xsl:template>
                                
    
</xsl:stylesheet>