<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />

    <xsl:template name="main-content">
        <xsl:variable name="mainContentCls"><xsl:call-template name="main-content-cls"/></xsl:variable>
        <div class="{$mainContentCls}">
            <div class="content__top__wrap">
                <xsl:call-template name="content-top" />
                <xsl:call-template name="content-panel" />
            </div>
            <div class="content content--paddin-sides">
                <!-- row -->
                <div class="row">
                    <!-- column -->
                    <xsl:variable name="colSize">
                        <xsl:choose>
                            <xsl:when test="$fixed-side-nav">col-xl-8</xsl:when>
                            <xsl:otherwise>col-xl-9</xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    <div class="{$colSize}">
                        <!-- content__inner -->
                        <div class="content__inner">
                            <xsl:call-template name="main-zone" />

                            <a class="theme-js-go-to g-pb-30" href="#topScroll">
                                <img src="{ametys:skinURL('/img/icon/arrow-up.png')}" alt="" />
                                <span class="g-font-size-16 color-grey g-font-primary-light">
                                    <i18n:text i18n:key="SKIN_BACK_TO_TOP" i18n:catalogue="skin.{$skin}" />
                                </span>
                            </a>
                        </div>
                        <!-- content__inner END -->
                    </div>
                    <!-- column END -->

                    <xsl:call-template name="right-content" />
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="right-content">
        <xsl:variable name="colSize">
            <xsl:choose>
                <xsl:when test="$fixed-side-nav">col-xl-4</xsl:when>
                <xsl:otherwise>col-xl-3</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <div class="{$colSize} g-mb-0--xl g-mb-30">
            <div class="r-side__inner">
                <div id="accordion-09" class="u-accordion" role="tablist" aria-multiselectable="true">
                    <xsl:call-template name="focus-zone"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>