/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
const skinManager = Ametys.serviceManager.lookup(org.ametys.web.skin.SkinsManager.ROLE);

// Get sites with intranet-cards skins
let siteNames = [];
Repository.query("//element(*, ametys:site)").forEach(function(site) {
    let skinId = site.getSkinId()
    if (skinId == 'intranet-cards' || skinManager.getSkin(skinId).getParents().contains("intranet-cards"))
    {
        siteNames.push(site.getName());
    }
});

updateMultimediaSearchServices(Repository.session);
updateMultimediaSearchServices(Repository.liveSession);

function updateMultimediaSearchServices(s)
{
    let count = 0;
    let xslt = "pages/services/search/search-multimedia.xsl";
  
    for (var i=0; i < siteNames.length; i++)
    {
      let query = `//element(${siteNames[i]}, ametys:site)//element(*, ametys:defaultPage)//element(*, ametys:zoneItem)[@ametys-internal:service='org.ametys.web.service.SearchService' and ametys:service_parameters/@ametys:xslt='${xslt}']`;
      
      Repository.query(query, true, s).forEach(function(zoneItem) {
        let params = zoneItem.getServiceParameters();  
        params.setValue("contentView", "multimedia");
        count++;
      });
    }
    
    s.save();
    logger.info(`${count} multimedia search services updated in workspace ${s.getWorkspace().getName()}`);
}