<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="plugin:ugc://pages/services/ugc/form.xsl"/>	
    
    <xsl:template name="gtu-field">
        <xsl:param name="gtu-mode"/>
        <xsl:param name="gtu-page-id"/>
        <xsl:param name="gtu-link-label"/>
        
        <div id="field-gtu-{$uniqueId}" class="field field-checkbox field-gtu">
             <xsl:call-template name="gtu-field-label"/>
             
             <xsl:call-template name="gtu-field-input"/>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="gtu-field-input">
        <div class="input input-checkbox" id="input-gtu-{$uniqueId}">
            <input type="checkbox" name="gtu" id="gtu-{$uniqueId}" value="true">
                <xsl:attribute name="data-ametys-mandatory">true</xsl:attribute>
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </input>
        </div>
    </xsl:template>
</xsl:stylesheet>		
