<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="">

	
	<xsl:template match="/">
		<html>
			<head>
				<title><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_HEAD" i18n:catalogue="plugin.web"/></title>
			</head>
			<body id="default">
				<div class="card-body">
	                <h1><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_TITLE" i18n:catalogue="plugin.web"/></h1>
	                <p><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_TEXT" i18n:catalogue="plugin.web"/></p>
	                <xsl:variable name="requestedURL" select="ametys:requestParameter('requestedURL')"/>
	                <xsl:if test="$requestedURL and $requestedURL != ''">
	                    <p><a href="{$requestedURL}"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGOUT_LINK" i18n:catalogue="plugin.web"/></a></p>
	                </xsl:if>
	            </div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
