<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="card mb-4 {$override-card-styles}">
            <xsl:call-template name="header"/>
            
            <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header">
        <header class="card-header card-header--space-between">
            <h1 class="card-title">
                <xsl:call-template name="card-header-icon"/>
                
                <xsl:choose>
                    <xsl:when test="$header != ''">
                        <xsl:value-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="header-default"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h1>
            <xsl:call-template name="link"/>
        </header>
   </xsl:template>
   
   <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <a class="card-link">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <xsl:call-template name="link-title"/>
            </a>
        </xsl:if>
    </xsl:template>
   
   <xsl:template name="link-default-title">
        <i18n:text i18n:key="SKIN_SEARCH_ALL" i18n:catalogue="skin.{$skin}"/>
   </xsl:template>
    
   <xsl:template name="header-default"/>
   
   <xsl:template name="card-header-icon"/>
   
   <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="search-results-class-attribute"/>
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
    
    <xsl:template name="search-results-class-attribute">
        <xsl:attribute name="class">card-body pt-0</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="hits-class-attribute"/>
    
   <xsl:template name="hits">
        <ul data-ametys-search-role="hits">
            <xsl:call-template name="hits-class-attribute"/>
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </ul>
    </xsl:template>
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
</xsl:stylesheet>