<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:variable name="common-service-css-class-name"></xsl:variable>
    
    <!-- Number max of visible tags (other tags wil be display in tooltip -->
    <xsl:variable name="maxVisibleTags">1</xsl:variable>
    
    <xsl:template name="common-service-head-css">    
        <link rel="stylesheet" href="{ametys:skinURL('zones/index-news-agenda/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="card mb-4 {$override-card-styles}">
            <xsl:call-template name="header"/>
            
            <xsl:call-template name="search-results"/>
        </div><script>
                $j(function () {
                  setTimeout(function () {
                    var maxTags = <xsl:value-of select="$maxVisibleTags"/>;

                    $j(".ametys-news-agenda__item .ametys-news-agenda__tags").each(function () {
                      var $tags = $j(this).find(".ametys-news-agenda__tags__tag");

                      if ($tags.length > maxTags) {
                        var nbTagRemove = $tags.length - maxTags;
                        $tags.slice(maxTags).remove();

                        // Create new "+X" tag with tooltip that contains the text of removed tags
                        var $newTag = $j("&lt;span&gt;", {
                          class: "ametys-news-agenda__tags__tag",
                          text: "+" + nbTagRemove,
                        });

                        var tooltipContent = $tags
                          .slice(maxTags)
                          .map(function () {
                            return $j(this).text();
                          })
                          .get()
                          .join(", ");

                        $newTag.attr("data-toggle", "tooltip");
                        $newTag.attr("data-placement", "top");
                        $newTag.attr("data-original-title", tooltipContent);
                        $newTag.attr("title", tooltipContent);
                        $newTag.tooltip();

                        // Add +X tag to the end
                        $j(this).append($newTag);
                      }
                      
                      // Create tooltip for each truncated tags if needed
                      $j(this).find(".ametys-news-agenda__tags__tag:not([data-toggle])").each(function () {
                        if ($j(this)[0].offsetHeight + 10 &lt; $j(this)[0].scrollHeight) 
                        {
                            $j(this).attr("data-toggle", "tooltip");
                            $j(this).attr("data-placement", "top");
                            $j(this).attr("data-original-title", $j(this).text());
                            $j(this).attr("title", $j(this).text());
                            $j(this).tooltip();
                        }
                      });
                    });
                  }, 200);
                });
              </script>
    </xsl:template>
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_NEWS_AGENDA" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <span class="card-header__icon material-icons access_time"></span>
    </xsl:template>
    
     <xsl:template name="hits-class-attribute">
     	<xsl:attribute name="class">ametys-news-agenda</xsl:attribute>
     </xsl:template>
     
     <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-news-agenda__item<xsl:text> </xsl:text>
    </xsl:template>
     
</xsl:stylesheet>
