<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
    <xsl:import href="plugin:multimedia://stylesheets/content/photo/photo-abstract.xsl"/>		
	<xsl:import href="skin://stylesheets/content/common-multimedia.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">home-view document </xsl:variable>
    
    <xsl:template name="content-default-image">
        <span class="icofont-duotone icofont-pictures"></span>
    </xsl:template>
    
    <!-- add fancybox -->
    <xsl:template name="common-content-head-js">    
        <script type="text/javascript">
            $j(function () {  // initialization of carousel
            $.HSCore.components.HSPopup.init('.js-fancybox');});
         </script>
    </xsl:template>
    
    <xsl:template name="content-link-class-attribute">
        <xsl:attribute name="class">js-fancybox ametys-webtv-list__item_link ametys-webtv--play</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-link-attribute">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')"/></xsl:attribute>
        <xsl:attribute name="target">_blank</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-image">
        <img src="{resolver:resolveCroppedImage(metadata/file/@type, metadata/file/@path, 480, 440)}" alt=""/>
    </xsl:template>
    
</xsl:stylesheet>
