<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    extension-element-prefixes="resolver ametys">
    
    <xsl:import href="plugin:calendar://pages/services/search/calendar.xsl"/>
<!--     <xsl:import href="skin://stylesheets/dates.xsl"/> -->
    
    <xsl:variable name="common-service-css-class-name">ametys-service-agenda</xsl:variable>
    <xsl:variable name="linkCssClass">btn</xsl:variable><!-- btn white -->
    
    <xsl:variable name="nbResultsPerPage">
    	<xsl:choose>
    		<xsl:when test="ametys:serviceViewParameter('nbResultsPerPage') != ''">
    			<xsl:value-of select="ametys:serviceViewParameter('nbResultsPerPage')"/>
    		</xsl:when>
    		<xsl:otherwise>4<!-- Default value --></xsl:otherwise>
    	</xsl:choose>
	</xsl:variable>
    <xsl:variable name="nbNextMonths">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('nbNextMonths') != ''">
                <xsl:value-of select="ametys:serviceViewParameter('nbNextMonths')"/>
            </xsl:when>
            <xsl:otherwise>3<!-- Default value --></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/agenda/scss/main.css')}" />
        
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="calendar-search-service-head-js"/>
        
        <xsl:call-template name="jquery-calendar"/>
        
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
        
        <script type="text/javascript">
            // Update carousel at initialization
            fetchInfo<xsl:value-of select="$serviceId"/>.needCarouselUpdate = true;
            
            function updateCarousel<xsl:value-of select="$serviceId"/>(eventsSelector){
                // reset carousel results
                $j('#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel div').remove();
                
                try{
                    // destroy carousel
                    $j('#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel').slick('unslick');
                } catch(e) {
                    // carousel not exist yet
                }         
                  
                // count events of the day
                eventsSelector = eventsSelector || '[data-ametys-search-role="search-results"] ul.list li[data-event-show="true"] a';
                var nbEvents =  $j(eventsSelector).length;
                
                if (nbEvents > 0)
                {
                    // create needed pages for carousel
                    let nbItems = Math.ceil(nbEvents / <xsl:value-of select="$nbResultsPerPage"/>);
                    for (i = 0; i &lt; nbItems; i++) {
                        $j('#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel').append(`&lt;div class="item" data-item="${i}"&gt;&lt;/div&gt;`);
                    }
                        
                    // copy active results on carousel    
                    let count = 0;
                    $j(eventsSelector).each(function() {
                        count++;
                        let itemNumber = Math.ceil(count / <xsl:value-of select="$nbResultsPerPage"/>);
                        $j(this).clone().appendTo(
                            `#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel .item:nth-of-type(${itemNumber})`)
                    });
                }
                else
                {
                    // No next events
                    $j('#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel').append(`&lt;div class="no-event"><i18n:text i18n:key="SKIN_SERVICE_CALENDAR_NO_NEXT_EVENT" i18n:catalogue="skin.{$skin}"/>&lt;/div>`);
                }
                
                $j('#calendar-search-service-<xsl:value-of select="$serviceId"/> .agenda-list-owl-carousel').slick({
                      regionLabel: "<i18n:text i18n:key="SKIN_CALENDAR_SEARCH_CAROUSEL_LABEL" i18n:catalogue="skin.{$skin}"/>",
                      ametysDotsBtnPrefixLabel: "<i18n:text i18n:key="SKIN_CALENDAR_SEARCH_CAROUSEL_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                      infinite: false,
                      autoplay: false,
                      dots: true,
                      arrows: false,
                      slidesToShow: 1,
                      slidesToScroll: 1
                });
                
                fetchInfo<xsl:value-of select="$serviceId"/>.needCarouselUpdate = false;
            }
        </script>
    </xsl:template>
    
    <xsl:template name="onload-callback">function(){
        var nbEvents =  $j('[data-ametys-search-role="search-results"] ul.list li[data-event-show="true"]').length;
        if (nbEvents == 0 &amp;&amp; fetchInfo<xsl:value-of select="$serviceId"/>.needCarouselUpdate)
        {
            // If no events for selected day, display next events (from today)
            var today = new Date();
            today.setHours(0, 0, 0, 0);
            var start = today.toISOString();
            var nbNextMonths = <xsl:value-of select="$nbNextMonths"/>;
            var end = new Date(today.getFullYear(), today.getMonth() + nbNextMonths, 0).toISOString();
            
            var $carouselLoading = $j("#calendar-search-service-<xsl:value-of select="$serviceId"/> [data-ametys-search-role='loading-carousel']");
            $carouselLoading.show();
             
            CalendarSearchService.launchSearch({
                   selector: "#calendar-search-service-<xsl:value-of select="$serviceId"/>",
                   searchResultsSelector: "[data-ametys-search-role='next-events']",
                   siteUriPrefix: "<xsl:value-of select="$site-uri-prefix"/>",
                   zoneItemId: "<xsl:value-of select="/search/zone-item/@id"/>",
                   siteName: "<xsl:value-of select="$site"/>",
                   lang: "<xsl:value-of select="$lang"/>",
                   resultMode: 'only-hits',
                   isSubmit: true
                }, 
                start, 
                end,
                function() {
                    var nextEventsSelector = '[data-ametys-search-role="next-events"] ul.list li a';

                    updateCarousel<xsl:value-of select="$serviceId"/>(nextEventsSelector);
                    
                    $carouselLoading.hide();
                },
                function() {
                    $carouselLoading.hide();
                }
            );
        }
        else if (fetchInfo<xsl:value-of select="$serviceId"/>.needCarouselUpdate) {
            updateCarousel<xsl:value-of select="$serviceId"/>();
        }
    }</xsl:template>
    
     <xsl:template name="onselect-callback">function(){
        updateCarousel<xsl:value-of select="$serviceId"/>();
     } </xsl:template>
     
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:if test="$header != ''">
            <div class="flex">
                <h1 class="service-title"><xsl:copy-of select="$header"/></h1>
                
                <xsl:call-template name="link-top"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="events-calendar" id="calendar-search-service-{$serviceId}">
            <xsl:call-template name="form-criteria"/>

            <div class="events-calendar-flex">
                 <div class="agenda-datepicker">
                    <div class="agenda-datepicker-inside">
                        <div id="calendar-{$serviceId}"></div>
                        <xsl:call-template name="loading-indicator"/>
                    </div>
                    <xsl:call-template name="download-links"/>
                </div>
                
                 <div class="agenda-list-carousel">
                    <div class="agenda-list-owl-carousel events">
                        <!-- events will be inserted here -->
                    </div>
                    
                    <xsl:call-template name="loading-carousel"/>
                </div>
            </div>

            <xsl:call-template name="link-bottom"/>
            
            <xsl:call-template name="search-results"/>
            
            <div data-ametys-search-role="next-events" style="display: none"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="loading-indicator">
        <div class="loading" data-ametys-search-role="loading"><i class="fas fa-spinner"/></div>
    </xsl:template>
    
     <xsl:template name="loading-carousel">
        <div class="loading" data-ametys-search-role="loading-carousel"><i class="fas fa-spinner"/></div>
    </xsl:template>
    
    <xsl:template name="hits">
        <script type="text/template" data-ametys-search-role="json-hits">
            {
                "events": [<xsl:for-each select="/search/hits/hit">
                                <xsl:apply-templates select="." mode="json"/>
                                <xsl:if test="position() != last()">,</xsl:if>
                           </xsl:for-each>]
            }
        </script>
    
        <xsl:if test="/search/hits/hit">
            <div data-ametys-search-role="hits">
                <ul class="list" style="display:none">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:sort select="content/attributes/start-date|event/startDate" order="ascending"/>
                        <xsl:apply-templates select="."/>
                   </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-js-submit-button">
        <xsl:variable name="code">
            fetchInfo<xsl:value-of select="$serviceId"/>.needCarouselUpdate = true;
            loadEvents<xsl:value-of select="$serviceId"/>();
            return false;
        </xsl:variable>
        <xsl:value-of select="normalize-space($code)"/>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']">
        <li data-event-id="{id}" style="display:none;">
            <a class="agenda-list-carousel-el">
                <xsl:apply-templates select="." mode="ics-event-url"/>
                <xsl:apply-templates select="." mode="ics-event-tag"/>
                <xsl:apply-templates select="." mode="ics-event-title"/>
                <xsl:apply-templates select="." mode="ics-event-date"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']" mode="ics-event-url">
        <xsl:attribute name="href"><xsl:value-of select="event/url"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']" mode="ics-event-tag">
        <xsl:if test="event/tag">
            <div class="agenda-list-carousel-el_tag"><xsl:value-of select="event/tag/label"/></div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']" mode="ics-event-title">
        <div class="agenda-list-carousel-el_title"><xsl:value-of select="event/title"/></div>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent='true']" mode="ics-event-date">
        <div class="agenda-list-carousel-el_date">
            <xsl:call-template name="common-utils-dates">
                <xsl:with-param name="startDate" select="event/startDate"/>
                <xsl:with-param name="endDate" select="event/endDate"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="link-top">
        <xsl:call-template name="link"/>
    </xsl:template> 
    
    <xsl:template name="link-bottom">
        <!-- <xsl:call-template name="link"/> -->
    </xsl:template> 
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="{$linkCssClass}">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <i class="fas fa-arrow-right"></i>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>