<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        xmlns:uri="org.ametys.core.util.URIUtils"
        extension-element-prefixes="resolver ametys filenameutils uri">
        
    <xsl:variable name="common-service-css-class-name">photo-gallery</xsl:variable>
    
    <xsl:variable name="imgSizeWidth">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('imgSizeWidth') != ''"><xsl:value-of select="ametys:serviceViewParameter('imgSizeWidth')"/></xsl:when>
            <xsl:otherwise>325</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="imgSizeHeight">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('imgSizeHeight') != ''"><xsl:value-of select="ametys:serviceViewParameter('imgSizeHeight')"/></xsl:when>
            <xsl:otherwise>200</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-css">    
        <link rel="stylesheet" href="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.min.css')}"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/photo-gallery/scss/main.css')}" media="screen, print, handheld"/>
    </xsl:template>  
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.jquery.min.js')}"></script>
        <script type="text/javascript">
            $j(function () {
                const gallery_<xsl:value-of select="$uniqueId"/> = $j('#gallery-photo-<xsl:value-of select="$uniqueId"/> a').simpleLightbox({
                    navText: ['&lt;span aria-hidden="true" class="fa fa-arrow-left">&lt;/span>', '&lt;span aria-hidden="true" class="fa fa-arrow-right">&lt;/span>'],
                    captionsData: 'alt',
                });
    	            
                gallery_<xsl:value-of select="$uniqueId"/>.on('shown.simplelightbox', function (e) {
                    // Add aria attributes
                    $j(this).attr("aria-pressed", true);
                    
                    const $lightbox = $j('.sl-wrapper.simple-lightbox');
                    $lightbox.attr("aria-label", "<i18n:text i18n:key="SKIN_NEWS_PHOTO_GALLERY_TITLE" i18n:catalogue="skin.{$skin}"/>");
                    $lightbox.attr("aria-modal", true);
                    $lightbox.find('.sl-close').attr("aria-label", "<i18n:text i18n:key="SKIN_NEWS_PHOTO_GALLERY_CLOSE_LABEL" i18n:catalogue="skin.{$skin}"/>");
                    $lightbox.find('.sl-prev').attr("aria-label", "<i18n:text i18n:key="SKIN_NEWS_PHOTO_GALLERY_NAV_PREV_LABEL" i18n:catalogue="skin.{$skin}"/>");
                    $lightbox.find('.sl-next').attr("aria-label", "<i18n:text i18n:key="SKIN_NEWS_PHOTO_GALLERY_NAV_NEXT_LABEL" i18n:catalogue="skin.{$skin}"/>"); 
                });
                
                gallery_<xsl:value-of select="$uniqueId"/>.on('closed.simplelightbox', function (e) {
                    $j('#gallery_<xsl:value-of select="$uniqueId"/> a[aria-pressed=true]').trigger('focus');
                    $j('#gallery_<xsl:value-of select="$uniqueId"/> a[aria-pressed=true]').attr("aria-pressed", false);
                });
           });
        </script>
    </xsl:template>
    
    <xsl:template name="photo-gallery-item">
        <xsl:param name="imgType"/>
        <xsl:param name="imgUri"/>
        <xsl:param name="filename"/>
        
        <li class="ametys-gallery-photo__item">
            <xsl:variable name="imgSrc" select="resolver:resolveCroppedImage($imgType, $imgUri, $imgSizeHeight, $imgSizeWidth)"/>
            
            <a aria-haspopup="dialog" aria-pressed="false" role="button" href="{resolver:resolve($imgType, $imgUri)}" style="background-image: url(&quot;{uri:encodePath($imgSrc)}&quot;)">
                  <xsl:if test="$rendering-context = 'back'">
                      <xsl:attribute name="internal">internal</xsl:attribute>
                  </xsl:if>
                  
                  <img src="{$imgSrc}" alt=""/>
             </a>
         </li>  
   </xsl:template>

</xsl:stylesheet> 
    
     