<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver filenameutils">

    <xsl:import href="service:web://pages/services/explorer-folder/common/files_3.3.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">attachments explorer-folder medium-icons
    	<xsl:if test="ametys:template() != 'index'">ametys-zone-file ametys-zone-file-internal</xsl:if>
    </xsl:variable>
    
    <xsl:variable name="maxLength">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('maxLength') != ''">
                <xsl:value-of select="ametys:serviceViewParameter('maxLength')"/>
            </xsl:when>
            <xsl:otherwise>4<!-- Default value --></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title">
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div>
        	<xsl:call-template name="class-attribute"/>
            
        	<xsl:call-template name="service-header"/>
            
            <xsl:call-template name="file-list"/>
       </div>
    </xsl:template>
    
    <xsl:template name="class-attribute">
        <xsl:if test="ametys:template() != 'index'">
            <xsl:attribute name="class">file-left</xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="file-list">
        <ul id="{$id}">
            <xsl:call-template name="list-class-attribute"/>
            
            <!-- Last modified documents -->
            <xsl:apply-templates select="Node[@type = 'resource']">
                <xsl:sort select="@lastModified" order="descending"/>
                <xsl:sort select="@name"/>
            </xsl:apply-templates>
        </ul>
    </xsl:template>
    
    <xsl:template name="list-class-attribute">
        <xsl:attribute name="class">file-list</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="service-header">
        <div class="flex-right">
            <h1 class="service-title"><xsl:value-of select="$header"/></h1>
            
            <xsl:call-template name="link-top"/>
        </div>
    </xsl:template>
    
    <xsl:template name="link-top">
        <xsl:variable name="allDocuments" select="ametys:serviceViewParameter('link')"/>
        <xsl:if test="$allDocuments">
             <a href="{resolver:resolve('page', $allDocuments, false(), true())}" class="btn">
                 <i class="fas fa-arrow-right" aria-hidden="true"></i>
                 <xsl:choose>
                    <xsl:when test="ametys:serviceViewParameter('linkTitle') != ''">
                        <xsl:value-of select="ametys:serviceViewParameter('linkTitle')"/>
                    </xsl:when>
                    <xsl:otherwise>
                         <i18n:text i18n:key="SERVICE_EXPLORER_FOLDER_SEE_ALL_DOCUMENTS" i18n:catalogue="skin.{$skin}"/>
                    </xsl:otherwise>
                 </xsl:choose>
             </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']">
    	<xsl:if test="position() &lt;= $maxLength or $maxLength = 0">
	        <li class="file-list-item">
                <xsl:apply-templates select="." mode="class-attribute"/>
                <a href="{resolver:resolve('explorer', @id, true())}" title="{@name}">
					<xsl:apply-templates select="." mode="icon"/>
					<xsl:apply-templates select="." mode="infos"/>
                </a>
	        </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="class-attribute">
        <xsl:attribute name="class">file-list-item</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="infos">
    	<div class="info">
    		<div class="title">
    			<xsl:value-of select="filenameutils:getBaseName(@name)"/>
    		</div>
    		<div class="format">
    			<xsl:text>.</xsl:text><xsl:value-of select="filenameutils:getExtension(@name)"/>
                <xsl:text> - </xsl:text>
                <xsl:call-template name="format-size"><xsl:with-param name="size" select="@size"/></xsl:call-template>
    		</div>
    	</div>
    </xsl:template>
	
	<xsl:template match="Node[@type = 'resource']" mode="icon">
		<div class="icon">
			<xsl:variable name="name" select="filenameutils:getExtension(@name)"/>
	    	<i aria-hidden="true">
	    		<xsl:attribute name="class"><xsl:text>fas fa-</xsl:text>
	    			<xsl:choose>
	    				<xsl:when test="$name = 'doc' or $name = 'docx' or $name = 'dot'">file-word</xsl:when>
	    				<xsl:when test="$name = 'avi' or $name = 'flv' or $name = 'mov' or $name = 'mpeg' or $name = 'mgp' or $name = 'swf' or $name = 'wmv'">file-video</xsl:when>
	    				<xsl:when test="$name = 'bmp' or $name = 'gif' or $name = 'jpeg' or $name = 'jpg' or $name = 'png' or $name = 'psd' or $name = 'psp'">file-image</xsl:when>
	    				<xsl:when test="$name = 'pdf'">file-pdf</xsl:when>
	    				<xsl:when test="$name = 'pps' or $name = 'ppsx' or $name = 'ppt' or $name = 'pptx'">file-powerpoint</xsl:when>
	    				<xsl:when test="$name = 'mid' or $name = 'mod' or $name = 'mp3'">file-audio</xsl:when>
	    				<xsl:when test="$name = 'xls' or $name = 'xlsx'">file-excel</xsl:when>
	    				<xsl:when test="$name = 'css' or $name = 'wml' or $name = 'xsl' or $name = 'htm' or $name = 'html' or $name = 'xhtml'">code</xsl:when>
	    				<xsl:when test="$name = 'tar' or $name = 'rar' or $name = 'zip' or $name = 'tgz' or $name = 'jar'">archive</xsl:when>
	    				<xsl:when test="$name = 'txt' or $name = 'odp' or $name = 'ods' or $name = 'odt' or $name = 'sxi' or $name = 'sxw'">file-alt</xsl:when>
						<xsl:when test="$name = 'cvs' or $name = 'sh' or $name = 'unkown' or $name = 'tgz' or $name = 'jar'">file</xsl:when>
	    				<xsl:otherwise>file</xsl:otherwise>
	    			</xsl:choose>
	    		</xsl:attribute>
	   		</i>
<!-- 	            <img class="icon" alt=""><xsl:attribute name="src"><xsl:value-of select="$uri-prefix"/><xsl:text>/plugins/explorer/icon-medium/</xsl:text><xsl:value-of select="filenameutils:getExtension(@name)"/><xsl:text>.png</xsl:text></xsl:attribute></img> -->
           </div>
	</xsl:template>
	
    <xsl:template name="Icons"/>
	<xsl:template name="FolderIcon"/>
    
</xsl:stylesheet>
