<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="ametys">
                
    <!-- <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/> -->
    
    <xsl:import href="plugin:web://pages/services/search/helpers/html/criteria.xsl"/>
    
    <!-- The placeholder for fulltext search field -->
    <xsl:variable name="searchInputPlaceholder" select="ametys:serviceViewParameter('searchInputPlaceholder')"/>

    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for  "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="field">
            <xsl:attribute name="class">
                <xsl:text>field </xsl:text>
                <xsl:apply-templates select="." mode="field-class-attribute"/>
            </xsl:attribute>
            
            <xsl:apply-templates select="." mode="field-label"/>
            
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-class-attribute">
        <xsl:text> field-select</xsl:text>
    </xsl:template>
    
    <xsl:template match="criterion[type='date' or type='datetime']" mode="field-class-attribute">
        <xsl:text> field-datepicker</xsl:text>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-class-attribute">
        <xsl:text> field-search</xsl:text>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-class-attribute">
        <xsl:text></xsl:text>
    </xsl:template>
    
    <xsl:template match="criterion[type = 'date' or type = 'datetime']" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" maxlength="10">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="field-input-title"/>
        </input>
        <xsl:call-template name="criterion-date-script-js"/>
    </xsl:template>
    
    <!-- Override to add "Cancel selection" and "Validate" buttons -->
    <xsl:template name="criterion-date-script-js">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <script type="text/javascript">
            (function(id)
            {
                var setCalsClearButton = function (year, month, elem) {
                  var afterShow = (function () {
                    var d = new $j.Deferred();
                    var cnt = 0;
                    setTimeout(function () {
                      if (elem.dpDiv[0].style.display === "block") {
                        d.resolve();
                      }
                      if (cnt >= 500) {
                        d.reject("datepicker show timeout");
                      }
                      cnt++;
                    }, 10);
                    return d.promise();
                  })();
        
                  afterShow.done(function () {
                    $j(".ui-datepicker").css("z-index", 2000);
        
                    var buttonPane = $j(elem)
                      .datepicker("widget")
                      .find(".ui-datepicker-buttonpane");
        
                    var btn = $j(
                      `&lt;button class="ui-datepicker-current ui-state-default ui-priority-primary clear-btn ui-corner-all" type="button"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DATEPICKER_CANCEL" i18n:catalogue="skin.{$skin}"/>&lt;/button>`
                    );
        
                    btn.off("click").on("click", function () {
                      $j(".ui-datepicker-calendar td").removeClass(
                        "ui-datepicker-current-day"
                      );
                      $j(".ui-datepicker-calendar td a").removeClass("ui-state-active");
                      $j.datepicker._clearDate(elem.input[0]);
                    });
        
                    btn.appendTo(buttonPane);
        
                    var btn2 = $j(
                      `&lt;button class="ui-datepicker-current ui-state-default ui-priority-primary validate-btn ui-corner-all" type="button"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DATEPICKER_VALIDATE" i18n:catalogue="skin.{$skin}"/>&lt;/button>`
                    );
        
                    btn2.off("click").on("click", function () {
                      $j.datepicker._hideDatepicker();
                    });
        
                    btn2.appendTo(buttonPane);
                  });
                };
        
                var odp = $j('#' + id);
                var ndp = odp.clone();
                ndp.attr('id', ndp.attr('id') + '-clone');
                ndp.attr('name', null);
                ndp.attr('value', '');
                ndp.attr('maxlength', '');
                ndp.keydown(function (event) {
                    if (event.which == 46 || event.which == 8) // del or backspace
                    {
                        ndp.datepicker("setDate", null);
                    }
                });
                
                var serverFormat = "yy-mm-dd";
                
                if (odp.attr("value") != "")
                {
                    $j(function () 
                    {
                        var existingDateAsString =  odp.attr("value") || '';
                        var existingDate = $j.datepicker.parseDate(serverFormat, existingDateAsString);
                        var reformatedDateAsString = $j.datepicker.formatDate('<i18n:text key="PLUGINS_WEB_FOWIDGET_DATE_FORMAT" i18n:catalogue="plugin.web"/>', existingDate); 
                        ndp.attr('value', reformatedDateAsString);
                    });
                }
                ndp.attr('readonly', 'readonly');
                ndp.appendTo(odp.parent());
                odp.css('visibility', 'hidden');
                odp.css('position', 'absolute');
                odp.css('top', '-1000px');
                odp.css('left', '-1000px');
                
                var opt = { 
                    dateFormat: '<i18n:text key="PLUGINS_WEB_FOWIDGET_DATE_FORMAT" i18n:catalogue="plugin.web"/>', 
                    altFormat: serverFormat, 
                    altField: '#' + id,
                    showButtonPanel: true,
                    beforeShow: function (inst, elem) {
                        setCalsClearButton(null, null, elem);
                    },
                    onSelect: function (dateText, inst, elem) {
                    },
                    onClose: function (date, inst) {
                      //Set inline to false => datapicker is closed
                      // onClose is called only if you click outside the datapicker, onSelect will not
                    },
                    onChangeMonthYear: setCalsClearButton
                };
                ndp.datepicker(opt);
            })("<xsl:value-of select="$id"/>");
        </script>
    </xsl:template>
    
    <!-- Override to allow placeholder and title attributes -->
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" class="text">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="field-input-title"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        
        <input id="{$id}" type="text" class="thematique" readonly="readOnly" onclick="openDropdownThematique(this)">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="field-input-title"/>
        </input>
        <button onclick="openDropdownThematique(this)" type="button" class="open-select-btn" aria-expanded="false" title="{label}"><span class="fas fa-caret-down" aria-hidden="true"></span></button>
        
        <div class="thematique-dropdown" role="group">
            <xsl:variable name="i18nparams"><label><xsl:value-of select="label"/></label></xsl:variable> 
            <xsl:attribute name="aria-label">
                <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_DROPDOWN_LABEL'), $lang, $i18nparams)"/>
            </xsl:attribute>
            <!-- Display search filter only if the number of enumeration items is higher than 10 (hide in JS) -->
            <div class="thematique-dropdown-search">
              <input type="search" title="skin.{$skin}:SKIN_SERVICE_SEARCH_DROPDOWN_FILTER_PLACEHOLDER" placeholder="skin.{$skin}:SKIN_SERVICE_SEARCH_DROPDOWN_FILTER_PLACEHOLDER" i18n:attr="placeholder title"/>
            </div>
            
            <ul class="thematique-dropdown-list">
                <xsl:apply-templates select="." mode="criterion-enumeration-all-option">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            
                <xsl:apply-templates select="." mode="criterion-enumeration-options">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </ul>
         </div>           
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="criterion-enumeration-all-option">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        
        <li class="thematique-dropdown-item">
            <input class="sr-only" type="checkbox" id="{@name}-all" name="{@name}" value="">
                <xsl:if test="not($value) or $value = ''"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
            </input>
            <label for="{@name}-all">
                <i18n:text i18n:key="SKIN_SERVICE_DROPDOWN_ALL_OPTION" i18n:catalogue="skin.{$skin}"/>
                <span class="sr-only">
                	<i18n:text i18n:key="SKIN_SERVICE_DROPDOWN_ALL_OPTION_ACCESSIBILITY_LABEL" i18n:catalogue="skin.{$skin}"/>
                </span>
            </label>
        </li>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="criterion-enumeration-options">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="name" select="@name"/>
        
        <xsl:for-each select="enumeration/item">
            <xsl:sort select="label" />
            
            <xsl:variable name="itemValue" select="@value" />
            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', ../../@definition)"></xsl:value-of></xsl:variable>
            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
            
            <xsl:if test="$compute-counts = 'false' or $count > 0">
              <li class="thematique-dropdown-item">
                    <input class="sr-only" type="checkbox" name="{$name}" id="{generate-id()}-{position()}" value="{$itemValue}">
                        <xsl:if test="$itemValue = $value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                    </input>
                    <label for="{generate-id()}-{position()}">
                        <xsl:call-template name="criterion-item-label">
                           <xsl:with-param name="count" select="$count" />
                        </xsl:call-template>
                    </label>
              </li>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="criterion-item-label">
        <xsl:param name="count" />
    
        <xsl:value-of select="label"/>
        <xsl:if test="$count">
            <span class="count-dropdown"> (<xsl:value-of select="$count" />)</span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:choose>
            <xsl:when test="$searchInputPlaceholder != ''">
                <xsl:attribute name="placeholder"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_TEXTFIELD_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_TEXTFIELD_PLACEHOLDER</xsl:attribute>
                <xsl:attribute name="i18n:attr">placeholder title</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-title">
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <!-- Default title is criteria label -->
    <xsl:template match="criterion" mode="field-input-title">
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <!-- Override to add sr-only class -->
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label for="{$id}" class="sr-only">
            <xsl:choose>
                <xsl:when test="$searchInputPlaceholder != ''"><xsl:value-of select="$searchInputPlaceholder"/></xsl:when>
                <xsl:otherwise><i18n:text i18n:key="SKIN_SERVICE_SEARCH_TEXTFIELD_PLACEHOLDER" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
            </xsl:choose>
        </label>
    </xsl:template>
    
    <!-- Override to add sr-only class -->
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="labelFor"><xsl:value-of select="$id"/><xsl:if test="type = 'date' or type = 'datetime'">-clone</xsl:if></xsl:variable>
        <label for="{$labelFor}" class="sr-only"><xsl:apply-templates select="." mode="field-label-text"/></label>
    </xsl:template>
    
</xsl:stylesheet>
