<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="ametys">
                
    <xsl:template name="rss">
        <xsl:if test="/search/RSSFeedURL != ''">
            
            <a href="{$site-uri-prefix}/{/search/RSSFeedURL}" class="first-link">
                <span class="icon-container icon-rss">
                  <xsl:call-template name="rss-icon"/>
                </span>
                <span class="text"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_RSS_TITLE" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="rss-icon">
        <svg
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 30.53 30.62"
                height="30.62"
                width="30.53"
              >
                <path
                  transform="translate(-1239.06 -1761.22)"
                  d="M1239.07,1771.65a20.16,20.16,0,0,1,20.16,20.2h-5.88a14.168,14.168,0,0,0-1.08-5.48,14.782,14.782,0,0,0-3.1-4.66,13.9,13.9,0,0,0-4.62-3.13,14.168,14.168,0,0,0-5.48-1.08v-5.85Zm0.04-10.43a30.373,30.373,0,0,1,21.54,8.98,30.431,30.431,0,0,1,6.53,9.75,30.03,30.03,0,0,1,2.41,11.9h-5.88a24.592,24.592,0,0,0-7.21-17.5,24.519,24.519,0,0,0-17.39-7.25v-5.88Zm7.58,24.48a4.041,4.041,0,0,0-1.49-1.47,4.1,4.1,0,0,0-2.07-.54,4.024,4.024,0,0,0-3.51,2.01,3.913,3.913,0,0,0-.55,2.05,4.01,4.01,0,0,0,.55,2.07,4.042,4.042,0,0,0,3.51,2.03,4.108,4.108,0,0,0,2.07-.55,3.993,3.993,0,0,0,1.49-1.48,4.1,4.1,0,0,0,.54-2.07A4,4,0,0,0,1246.69,1785.7Z"
                  class="cls-1"
                  id="icon-flux"
                ></path>
              </svg>
    </xsl:template>
    
</xsl:stylesheet>

