<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:docbook="http://docbook.org/ns/docbook"
    exclude-result-prefixes="docbook ametys resolver">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:template name="common-content-body">
        <xsl:call-template name="common-content-body-title"/>
        <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
    
   <!-- Link used for the view link -->
    <xsl:template name="common-content-body-link">
        <xsl:param name="title" select="metadata/title"/>
        
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}">
                	<xsl:call-template name="content-body-link-icon"/>
                	<xsl:value-of select="$title"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
            	<xsl:call-template name="content-body-link-icon"/>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>  
    
    <xsl:template name="content-body-link-icon">
    	<i class="fas fa-circle" style="font-size: small;"></i>
    </xsl:template>
    
</xsl:stylesheet>    