<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys resolver">

	<xsl:import href="plugin:news://stylesheets/content/news/news-link.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-link.xsl"/>
	
	<xsl:template name="content-body-link-icon">
    	<i class="fas fa-clock"></i>
    </xsl:template>
    
    <!-- Link used for the view link -->
    <xsl:template name="common-content-body-content">
        <xsl:param name="title" select="metadata/title"/>
        
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}">
                	<xsl:call-template name="content-body-link-icon"/>
                	
                	<!-- Dates -->
			        <xsl:if test="metadata/start-date or metadata/end-date">
			            <xsl:call-template name="dates">
			                <xsl:with-param name="startDate" select="metadata/start-date"/>
			                <xsl:with-param name="endDate" select="metadata/end-date"/>
			            </xsl:call-template>
			        </xsl:if>
        
                	<span class="title"><xsl:value-of select="$title"/></span>
                </a>
            </xsl:when>
            <xsl:otherwise>
            	<xsl:call-template name="content-body-link-icon"/>
            	
            	<!-- Dates -->
		        <xsl:if test="metadata/start-date or metadata/end-date">
		            <xsl:call-template name="dates">
		                <xsl:with-param name="startDate" select="metadata/start-date"/>
		                <xsl:with-param name="endDate" select="metadata/end-date"/>
		            </xsl:call-template>
		        </xsl:if>
        
                <span class="title"><xsl:value-of select="$title"/></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>  
	
</xsl:stylesheet>
