<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:math="http://exslt.org/math" 
                extension-element-prefixes="ametys math exslt">
    
    <xsl:import href="plugin:web://pages/comments/helper/comments_4.8.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl" />
    
    <!-- Order comments in descending order -->
    <xsl:variable name="sortCommentsAsc">false</xsl:variable>
    <xsl:variable name="loadCommentsCallback">loadCommentsCb_<xsl:value-of select="$uniqueId"/></xsl:variable>
    
    <xsl:template name="comments-title">
        <a name="comments-{@id}"/>
        <h2 class="comments-count">
            <span data-ametys-nb-comments="true"></span>
            <xsl:text> </xsl:text>
            <span data-ametys-comments-title="true">
                <i18n:text i18n:key="SKIN_COMMENTS_TITLE" i18n:catalogue="skin.{$skin}"/>
            </span>
        </h2>
    </xsl:template>
    
    <xsl:template name="comments-rss">
        <a class="comments-rss" data-ametys-comment-rss="true" title="skin.{$skin}:SKIN_COMMENTS_RSS_TITLE" i18n:attr="title" href="{$site-uri-prefix}/_plugins/web/comments/rss.xml?contentId={@id}&amp;siteName={$site}">
            <i18n:text i18n:key="SKIN_COMMENTS_RSS" i18n:catalogue="skin.{$skin}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="comments-loader">
        <div class="comments-loader" style="display:none">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="51px" height="51px"
                viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                <circle cx="50" cy="50" fill="none" stroke="#0a0a0a" stroke-width="10" r="35" stroke-dasharray="164.93361431346415 56.97787143782138">
                    <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform>
                </circle>
            </svg>
        </div>
    </xsl:template>
        
    <xsl:template name="comments-additional-js">
        <script>
            $j(function(){
                getAmetysUser(function(user) {
                    if (user)
                    {
                        // Fill form inputs
                        var $form = $j('[data-ametys-comments-form="<xsl:value-of select="@id"/>"]');
                        $form.find('input[name=name]').val(user.fullname);
                        $form.find('input[name=email]').val(user.email);
                        
                        // Update current user image
                        $form.find('[data-current-user-img]').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/core-ui/user/' + user.populationId + '/' + encodeURIComponent(user.login) + '/image_45?lang=<xsl:value-of select="$lang"/>');
                    }
                });
                
                AmetysFront.Event.listen("comments-loading", function(data) {
                    // Show loader
                    $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"] .comments-loader').show();
                })
                
                AmetysFront.Event.listen("comments-loaded", function(data) {
                    // Hide loader
                    $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"] .comments-loader').hide();
                })
            });
                
            // Show/hide answer form
            function toggleAnswerForm_<xsl:value-of select="$uniqueId"/>(btn) 
            {
                var formId = $j(btn).attr("aria-controls");
                var $form = $j('#' + formId);
                
                if ($form.is(':visible'))
                {
                    $form.hide();
                    $j(btn).attr("aria-expanded", false);
                }
                else
                {
                    $form.show();
                    $form.find("textarea[name=text]").trigger('focus');
                    $j(btn).attr("aria-expanded", true);
                }
            }
            
            // Callback function call after loading comments
            function loadCommentsCb_<xsl:value-of select="$uniqueId"/>(comments, contentId) 
            {
                updateCommentsTitle_<xsl:value-of select="$uniqueId"/>();
                
                // Update like buttons
                $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"] .ametys-comment-like-btn').each(function (i, btn) {
                    let like = $j(btn).attr("data-ametys-comment-own-liker");
                    if (like == 'true')
                    {
                        $j(btn).attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_UNLIKE_BUTTON_TITLE" i18n:catalogue="plugin.cms" />");
                        $j(btn).attr("aria-label", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_UNLIKE_BUTTON_TOOLTIP" i18n:catalogue="plugin.cms" />");
                        $j(btn).addClass("active");
                    }
                    else
                    {
                        $j(btn).attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_LIKE_BUTTON_TITLE" i18n:catalogue="plugin.cms" />");
                        $j(btn).attr("aria-label", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_LIKE_BUTTON_TOOLTIP" i18n:catalogue="plugin.cms" />");
                        $j(btn).removeClass("active");
                    }
                });
                
                $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"] [data-ametys-comment-nb-likes]').each(function(){
                    if ($j(this).html() != '')
                    {
                        // show likes counter
                        $j(this).closest('.ametys-likes-counter').show();
                    }
                });
                
            }
            
            // Callback function after deleting a comment
            function deleteCommentCb_<xsl:value-of select="$uniqueId"/>(results, args) 
            {
                updateCommentsTitle_<xsl:value-of select="$uniqueId"/>(results, args);
                
                // replace focus
                let $wrapper = $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"]');
                let $commentsHeader = $wrapper.find('.comments-count');
                $commentsHeader.attr("tabindex", -1);
                $commentsHeader.trigger('focus');
            }
            
            function updateCommentsTitle_<xsl:value-of select="$uniqueId"/>(results, args)
            {
                let $wrapper = $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"]');
                let $commentsTitle = $wrapper.find('[data-ametys-comments-title]');
                let $nbComments = $wrapper.find('[data-ametys-nb-comments]');
                let nbComments = $wrapper.find('[data-ametys-comments] > li').length;
                
                if (nbComments == 0)
                {   
                    $commentsTitle.html("<i18n:text i18n:key="SKIN_COMMENTS_TITLE" i18n:catalogue="skin.{$skin}"/>");
                    $nbComments.hide();
                }
                else if (nbComments == 1)
                {   
                    $commentsTitle.html("<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_COUNT_ONE" i18n:catalogue="plugin.cms" />");
                    $nbComments.show();
                }
                else
                {
                    $commentsTitle.html("<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_COUNT" i18n:catalogue="plugin.cms" />");
                    $nbComments.show();
                }
            }
            
            function updateLikeBtn_<xsl:value-of select="$uniqueId"/>(result, args)
            {
                let $likeBtn = $j(args.btn);
                let like = $likeBtn.attr("data-ametys-comment-own-liker");
                if (like == 'true')
                {
                    $likeBtn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_UNLIKE_BUTTON_TITLE" i18n:catalogue="plugin.cms" />");
                    $likeBtn.addClass("active");
                    $likeBtn.attr("aria-pressed", true);
                }
                else
                {
                    $likeBtn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_LIKE_BUTTON_TITLE" i18n:catalogue="plugin.cms" />");
                    $likeBtn.removeClass("active");
                    $likeBtn.attr("aria-pressed", false);
                }
                
                if (result.nbLikes > 0)
                {
                    // Display counter
                    $likeBtn.next().show();
                }
                else
                {
                    // Hide counter
                    $likeBtn.next().hide();
                }
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-comment-template">
        <li data-ametys-comment-id="%%id%%" data-ametys-is-comment="true">
            <a name="%%id%%-{@id}"/>
            
            <xsl:call-template name="comment-author-avatar"/>
            
            <div class="comment__inner">
                <xsl:call-template name="comment-author"/>
                
                <xsl:call-template name="comment-content"/>
                
                <xsl:call-template name="comment-footer">
                    <xsl:with-param name="level" select="'0'" />
                </xsl:call-template>
                
                <xsl:call-template name="comment-subcomments"/>
                
                <xsl:call-template name="comment-answer-form"/>
            </div>
        </li>   
        
        <!-- Script should be always the last element of template-->
        <xsl:call-template name="comment-script"/>
    </xsl:template>
    
    <xsl:template name="comment-script">
        <script type="text/javascript">
            // Here the scripts that should be executed after comment insertion
            {
                let comment = $j('[data-ametys-comment-id="%%id%%"][data-ametys-is-comment]');
                
                $j(function(){
                    // Fill form inputs
                    comment.find('input[name=name]').val(ametysUser.fullname);
                    comment.find('input[name=email]').val(ametysUser.email);
                    
                    // Update current user image
                    comment.find('[data-current-user-img]').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/core-ui/user/' + ametysUser.populationId + '/' + encodeURIComponent(ametysUser.login) + '/image_45?lang=<xsl:value-of select="$lang"/>');
                   
                   // Transform to moment date
                    comment.find('> .comment__inner [data-relativedate]').each(function() {
                        let date = $j(this).data('relativedate');
                        $j(this).html('- ' + AmetysFront.Utils.toRelativeDate(date));
                    });
                });
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-subcomment-template">
        <li data-ametys-comment-id="%%id%%" data-ametys-is-comment="true">
            <a name="%%id%%-{@id}"/>
            
            <xsl:call-template name="comment-author-avatar"/>
            
            <div class="comment__inner">
                <xsl:call-template name="comment-author"/>
                
                <xsl:call-template name="comment-content"/>
                
                <xsl:call-template name="comment-footer">
                    <xsl:with-param name="level" select="'1'" />
                </xsl:call-template>
            </div>
        </li>   
        
        <!-- Script should be always the last element of template-->
        <xsl:call-template name="comment-script"/>
    </xsl:template>
    
    <xsl:template name="comment-author-avatar">
        <div class="comment-img">
            <img src="%%author.imgUrl%%" alt=""/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-author">
        <div class="comment-author">%%author-name%%
            <xsl:call-template name="comment-date"/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-date">
        <span class="comment-creation" data-relativedate="%%creation-date%%">
        </span>
    </xsl:template>
    
    <xsl:template name="comment-content">
        <div class="comment-content">
            <p>%%content%%</p>
        </div>    
    </xsl:template> 
    
    <xsl:template name="comment-footer">
        <xsl:param name="level" />
        
        <div class="comment-footer" >
            <div class="comment-footer__buttons">
                <xsl:call-template name="comment-report-btn"/>
                
                <xsl:call-template name="comment-delete-btn"/>
    
                <xsl:call-template name="comment-like"/>
            </div>
            
            <xsl:if test="$level = 0">
                <xsl:call-template name="comment-answer-form-button" />
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-answer-form-button">
        <p class="answer-comment">
            <button type="button"
                aria-label="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_ANSWER_TITLE" i18n:attr="aria-label"
                aria-expanded="false"
                aria-controls="form-%%id%%-{$uniqueId}"
                onclick="toggleAnswerForm_{$uniqueId}(this)">
                <i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_ANSWER_TITLE" i18n:catalogue="plugin.cms"/>
            </button>
        </p>
    </xsl:template>
    
    <!-- Main comment form is always visible -->
    <xsl:template name="comment-form">
        <div class="comment-form">
            <form method="post" data-ametys-comments-form="{@id}">
                <xsl:call-template name="comment-form-inner"/>
            </form>
        </div>
    </xsl:template>
    
    
    <xsl:template name="comment-form-field-name">
        <input type="hidden" name="name" value=""/>
    </xsl:template>
    
    <xsl:template name="comment-form-field-mail">
        <input name="email" type="hidden" value=""/>
    </xsl:template>
    
    <xsl:template name="comment-form-field-url">
        <input name="url" type="hidden" value=""/>
    </xsl:template> 
    
    <xsl:template name="comment-form-field-hidemail">
        <input name="hide-email" type="hidden" value=""/>
    </xsl:template> 
    
    <xsl:template name="comment-form-field-captcha">
        <!-- No captcha required on intranet -->
    </xsl:template> 
    
    <xsl:template name="comment-form-field-content">
        <xsl:param name="level" />
        <xsl:param name="comment-id" />
        <xsl:param name="commentUniqueId" />
        
        <div class="comment-form-field-content">
            <div class="comment-form-field-content__img">
                <img data-current-user-img="true" alt=""/>
            </div>
            <div class="comment-form-field-content__input">  
                <label for="{$commentUniqueId}-text" class="sr-only">
                    <i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_CONTENT" i18n:catalogue="plugin.cms"/>
                </label>  
                <textarea id="{$commentUniqueId}-text" aria-required="true" title="skin.{$skin}:SKIN_COMMENTS_CONTENT_PLACEHOLDER" placeholder="skin.{$skin}:SKIN_COMMENTS_CONTENT_PLACEHOLDER" i18n:attr="title placeholder" name="text"></textarea>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-form-field-submit">
        <xsl:param name="level">0</xsl:param>
        <xsl:param name="comment-id"/>
        
        <button type="button" class="comment-form-submit-btn" 
                aria-label="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_SUBMIT" 
                title="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_SUBMIT" 
                i18n:attr="title aria-label" 
                role="submit">
                
                <xsl:attribute name="onclick">
                    <xsl:choose>
                        <xsl:when test="$level = 0">AmetysFront.Comments.addComment('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@id"/>', <xsl:value-of select="$sortCommentsAsc"/>, updateCommentsTitle_<xsl:value-of select="$uniqueId"/>)</xsl:when>
                        <xsl:otherwise>AmetysFront.Comments.addSubComment(this, '<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@id"/>', <xsl:value-of select="$sortSubCommentsAsc"/>)</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <span class="fas fa-paper-plane" aria-hidden="true"></span>
         </button>
    </xsl:template>
    
    <xsl:template name="comment-report-btn">
        <button class="ametys-comment-report-btn" 
              data-ametys-comment-report="true"
              data-ametys-comment-id="%%id%%"
              title="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_REPORT_BUTTON_TOOLTIP"
              i18n:attr="title"
              aria-haspopup="dialog"
              onclick="AmetysFront.Comments.reportComment(this,'{@id}', $j(this).attr('data-ametys-comment-id'))">
            <span class="fas fa-exclamation-triangle" aria-hidden="true"></span>
        </button>
    </xsl:template>
    
    <xsl:template name="comment-delete-btn">
        <button class="ametys-comment-delete-btn" 
              data-ametys-comment-delete="true"
              data-ametys-comment-id="%%id%%"
              title="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_DELETE_BUTTON_TOOLTIP"
              i18n:attr="title"
              aria-haspopup="dialog"
              onclick="AmetysFront.Comments.deleteComment(this, '{@id}', $j(this).attr('data-ametys-comment-id'), deleteCommentCb_{$uniqueId})">
            <span class="fas fa-trash-alt" aria-hidden="true"></span>
        </button>
    </xsl:template>
    
    <xsl:template name="comment-like">
        <div data-nblike="" class="ametys-comment-like" data-ametys-comment-like="true">
            <button class="ametys-comment-like-btn" 
                  aria-pressed="%%own-liker%%" 
                  data-ametys-comment-own-liker="%%own-liker%%" 
                  data-ametys-comment-id="%%id%%" 
                  data-ametys-comment-likers="%%likers%%"
                  title="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_LIKE_BUTTON_TITLE"
                  i18n:attr="title"
                  onclick="AmetysFront.Comments.likeOrUnlikeComment(this, '{@id}', $j(this).attr('data-ametys-comment-id'), $j(this).attr('data-ametys-comment-own-liker') == 'true', updateLikeBtn_{$uniqueId})">
            </button>
            <div class="ametys-likes-counter" style="display: none;">
                <span class="ametys-like-count" data-ametys-comment-nb-likes="true">%%nb-likes%%</span>
                <span class="sr-only"><xsl:text> </xsl:text><i18n:text i18n:key="SKIN_COMMENTS_LIKE_TEXT" i18n:catalogue="skin.{$skin}"/></span>
            </div>
        </div>
    </xsl:template>
    
    
</xsl:stylesheet>