<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:import href="plugin:newsletter://pages/services/list/list_1.4.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/newsletter/scss/main.css')}"/>
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <div class="flex">
            <xsl:call-template name="common-service-body-nonempty-content-title-content">
                <xsl:with-param name="title" select="$service-title"/>  
                <xsl:with-param name="default-title"><i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_DESCRIPTION" i18n:catalogue="plugin.newsletter"/></xsl:with-param>            
            </xsl:call-template>
            
            <xsl:call-template name="rss"/>
        </div>
    </xsl:template>
    
    <!-- Template for the rss link -->
    <xsl:template name="rss">
        <xsl:if test="/Newsletters/rss/@url">
            <div class="rss">
                <a href="{$uri-prefix}/{/Newsletters/rss/@url}" class="first-link">
                    <span class="icon-container icon-rss">
                        <xsl:call-template name="icon-rss"/>
                    </span>
                    <span class="text">
                        <i18n:text i18n:key="NEWSLETTERS_SERVICE_LIST_RSS_FEED_ALT" i18n:catalogue="plugin.newsletter"/>
                    </span>
                </a>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="icon-rss">
        <svg xmlns="http://www.w3.org/2000/svg" width="30.53" height="30.62" viewBox="0 0 30.53 30.62">
          <path id="icon-flux" class="cls-1" d="M1239.07,1771.65a20.16,20.16,0,0,1,20.16,20.2h-5.88a14.168,14.168,0,0,0-1.08-5.48,14.782,14.782,0,0,0-3.1-4.66,13.9,13.9,0,0,0-4.62-3.13,14.168,14.168,0,0,0-5.48-1.08v-5.85Zm0.04-10.43a30.373,30.373,0,0,1,21.54,8.98,30.431,30.431,0,0,1,6.53,9.75,30.03,30.03,0,0,1,2.41,11.9h-5.88a24.592,24.592,0,0,0-7.21-17.5,24.519,24.519,0,0,0-17.39-7.25v-5.88Zm7.58,24.48a4.041,4.041,0,0,0-1.49-1.47,4.1,4.1,0,0,0-2.07-.54,4.024,4.024,0,0,0-3.51,2.01,3.913,3.913,0,0,0-.55,2.05,4.01,4.01,0,0,0,.55,2.07,4.042,4.042,0,0,0,3.51,2.03,4.108,4.108,0,0,0,2.07-.55,3.993,3.993,0,0,0,1.49-1.48,4.1,4.1,0,0,0,.54-2.07A4,4,0,0,0,1246.69,1785.7Z" transform="translate(-1239.06 -1761.22)"/>
        </svg>
    </xsl:template>
	
</xsl:stylesheet>
