<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver ametys">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>
 	
    <xsl:template name="body">
        <xsl:call-template name="logo"/>
        
        <div>
            <div class="connect-account">
                <xsl:call-template name="body-existingaccount-title"/>
                
                <xsl:call-template name="show-hint"/>
                <xsl:call-template name="show-errors"/>
                <xsl:call-template name="login"/>
            </div>
            
            <xsl:call-template name="signup"/>
        </div>
    </xsl:template>
    
    <xsl:template name="body-title"/>
    
    <xsl:template name="login">
        <div class="login ametys-cms-content">
            <xsl:call-template name="login-title"/>
            
            <xsl:call-template name="login-user-populations-standalone"/>
            
            <xsl:call-template name="login-credential-providers"/>
            
            <xsl:call-template name="login-multifactor-authentication"/>
        </div>
    </xsl:template>
    
    <xsl:template name="logo">
        <div class="logo">
            <img src="{ametys:skinURL('templates/common/img/logo-white.png')}" class="logo" alt="{ametys:siteParameter('title')}"/>
        </div>
    </xsl:template>
    
    <xsl:template name="login-title">
        <h1 class="ametys-richtext-title-1"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></h1>
    </xsl:template> 
    
    <xsl:template name="body-existingaccount-title"/>
    
    <xsl:template name="show-hint"/>
    
    <xsl:template name="signup"/>
    
</xsl:stylesheet>
