<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
        
    <xsl:import href="plugin:web://pages/services/contenttype/helper/form.xsl"/> 
    <xsl:import href="common.xsl"/>
    
    <xsl:template name="contenttype-form-header">
        <xsl:param name="view"/>
        
        <xsl:if test="$view//metadata[@type = 'rich-text']">
            <script type="text/javascript" src="{ametys:pluginResourceURL('tiny_mce', 'js/tinymce.js')}"></script>
        </xsl:if>
        
        <xsl:call-template name="input-select-js"/>
        
        <xsl:if test="$view//metadata[@type = 'file']">
            <xsl:call-template name="input-file-js"/>
            <xsl:call-template name="input-image-file-js"/>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template match="metadata[@type='file']" mode="contenttype-form-field">
        <xsl:param name="fieldId" select="translate(@path, '/', '-')"/>
        <xsl:param name="fieldName" select="translate(@path, '/', '.')"/>
        <xsl:param name="values"/>
        <xsl:param name="value" select="$values/*[local-name() = $fieldName]"/>
        <xsl:param name="errors" />
        <xsl:param name="uniqueId" />
        
        <xsl:choose>
            <xsl:when test="widget-params/param[@name = 'filter'] = 'image'">
                <div id="field-{$fieldId}-{$uniqueId}" class="download-image-item">
                    <div class="preview preview-{$fieldId}">
                        <img src="" alt=""/>
                        <button class="close" onclick="closePreview(this)" aria-label="skin.{$skin}:SKIN_FORMS_DELETE_IMAGE" i18n:attr="aria-label">
                            <span class="material-icons" aria-hidden="true">close</span>
                        </button>
                    </div>
                    <label for="{$fieldId}-{$uniqueId}" class="add-photo">
                        <xsl:if test="$errors[@name = $fieldName]/error">
                            <xsl:attribute name="class">input invalid</xsl:attribute>
                        </xsl:if>
                           
                        <xsl:call-template name="photo-icon"/>
                        <span><i18n:text i18n:key="SKIN_FORMS_SELECT_IMAGE" i18n:catalogue="skin.{$skin}"/></span>
                        <xsl:call-template name="contenttype-form-field-mandatory" />
                   
                        <input id="{$fieldId}-{$uniqueId}" type="file" name="{$fieldName}" onchange="changePhoto(this, '{$fieldId}')" accept="image/*">
                          <xsl:if test="validation/mandatory = 'true'"><xsl:attribute name="data-ametys-mandatory">true</xsl:attribute></xsl:if>
                        </input>
                        <input type="hidden" name="photo-{$fieldId}" id="photo-{$fieldId}" />
                    </label>
                 </div>
            </xsl:when>
            <xsl:otherwise>
                <div id="field-{$fieldId}-{$uniqueId}" class="download-item download-{$fieldId}">
                     <xsl:if test="$errors[@name = $fieldName]/error">
                        <xsl:attribute name="class">input invalid</xsl:attribute>
                     </xsl:if>
                    <h2 class="ametys-richtext-title-4">
                        <i18n:text i18n:key="SKIN_FORMS_FILE_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
                        <xsl:text> </xsl:text>
                        <xsl:copy-of select="label/node()" />
                        <xsl:call-template name="contenttype-form-field-mandatory" />
                    </h2>
                    <div id="input-{$fieldId}-{$uniqueId}"> 
                    <label>
                        <input id="{$fieldId}-{$uniqueId}" type="file" name="{$fieldName}" onchange="changeFile(this, '{$fieldId}')">
                            <xsl:if test="validation/mandatory = 'true'"><xsl:attribute name="data-ametys-mandatory">true</xsl:attribute></xsl:if>
                        </input>
                        <xsl:call-template name="download-icon"/>
                        <span><i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/></span>
                    </label>
                    <button class="close" onclick="removeFile(this)" aria-label="skin.{$skin}:SKIN_FORMS_DELETE_FILE" i18n:attr="aria-label">
                        <span class="material-icons" aria-hidden="true">close</span>
                    </button>
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        <script>
                // Handle focus visivility for accessibility purpose
                $j('#<xsl:value-of select="$fieldId"/>-<xsl:value-of select="$uniqueId"/>').on('focus', function() {
                    if ($j(this).is(':focus-visible'))
                    {
                        $j(this).closest('.download-item').addClass("focus-visible");
                        $j(this).closest('.download-image-item').addClass("focus-visible");
                    }
                })
                $j('#<xsl:value-of select="$fieldId"/>-<xsl:value-of select="$uniqueId"/>').on('blur', function() {
                    $j(this).closest('.download-item').removeClass("focus-visible");
                    $j(this).closest('.download-image-item').removeClass("focus-visible");
                })
        </script>
    </xsl:template>
    
    <!-- Override template to add 'checkbox' class -->
    <xsl:template match="metadata[@type='boolean']" mode="contenttype-form-field">
        <xsl:param name="fieldId" select="translate(@path, '/', '-')"/>
        <xsl:param name="fieldName" select="translate(@path, '/', '.')"/>
        <xsl:param name="values"/>
        <xsl:param name="value" select="$values/*[local-name() = $fieldName]"/>
        <xsl:param name="errors" />
        <xsl:param name="uniqueId" />
        
        <div id="field-{$fieldId}-{$uniqueId}" class="field checkbox field-{$fieldId}">
             <xsl:apply-templates select="." mode="contenttype-form-field-label"/>
             
             <div id="input-{$fieldId}-{$uniqueId}" class="input">
                <xsl:if test="$errors[@name = $fieldName]/error">
                    <xsl:attribute name="class">input invalid</xsl:attribute>
                 </xsl:if>
                <input id="{$fieldId}-{$uniqueId}" type="checkbox" name="{$fieldName}">
                    <xsl:if test="$value = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                </input>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>       