<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                xmlns:exslt="http://exslt.org/common" 
                extension-element-prefixes="resolver filenameutils exslt">
	
	<xsl:import href="service:web://pages/services/explorer-folder/files_default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">last-documents page</xsl:variable>
    
    <xsl:variable name="maxSize">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('maxSize') != '' and ametys:serviceViewParameter('maxSize') &gt; 0">
                <xsl:value-of select="ametys:serviceViewParameter('maxSize')"/>
            </xsl:when>
            <xsl:otherwise>6<!-- Default value --></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
	<xsl:template name="attachment-list">
        <xsl:variable name="documents">
            <xsl:for-each select=".//Node[@type = 'resource']">
                <xsl:sort select="@lastModified" order="descending"/>
                <xsl:copy-of select="."></xsl:copy-of>
            </xsl:for-each>
        </xsl:variable>
        
        <ul class="documents">
            <xsl:apply-templates select="exslt:node-set($documents)/Node[@type = 'resource' and position() &lt;= $maxSize]"/>
        </ul>
        
        <xsl:call-template name="link-bottom"/>
   </xsl:template>
   
   <xsl:template match="Node[@type = 'resource']">
        <li class="document">
            <a href="{resolver:resolve('explorer', @id, true())}">
                <xsl:call-template name="file-link-title"/>
                <div class="left">
                    <xsl:call-template name="file-icon">
                        <xsl:with-param name="filename" select="@name"/>
                    </xsl:call-template>
                    <span class="title"><xsl:value-of select="@name"/></span>
                </div>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="file-link-title">
        <xsl:param name="filename" select="@name"/>
        <xsl:param name="size" select="@size"/>
        
        <xsl:variable name="formattedSize">
            <xsl:call-template name="format-size-in-attribute">
                <xsl:with-param name="size" select="$size"></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="i18nparams"><filename><xsl:value-of select="$filename"/></filename><size><xsl:value-of select="$formattedSize"/></size></xsl:variable> 
        
        <xsl:attribute name="title">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
        </xsl:attribute>
        <xsl:attribute name="aria-label">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SKIN_DOCUMENT_DOWNLOAD_TITLE_WITH_SIZE'), $lang, $i18nparams)"/>
        </xsl:attribute>
            
   </xsl:template>
    
    <xsl:template name="link-bottom">
        <xsl:variable name="allDocuments" select="ametys:serviceViewParameter('link')"/>
        <xsl:if test="$allDocuments">
             <a href="{resolver:resolve('page', $allDocuments, false(), true())}" class="btn desktop">
                <span class="plus" aria-hidden="true">+</span>
                <span>
                     <xsl:choose>
                        <xsl:when test="ametys:serviceViewParameter('linkTitle') != ''">
                            <xsl:value-of select="ametys:serviceViewParameter('linkTitle')"/>
                        </xsl:when>
                        <xsl:otherwise>
                             <i18n:text i18n:key="SKIN_EXPLORER_FOLDER_ALL_DOCUMENTS" i18n:catalogue="skin.{$skin}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                 </span>
             </a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>		
