<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-css-class-name">kiosque-section</xsl:variable>
    
    <xsl:variable name="openFlipbookInPopup" select="ametys:serviceViewParameter('openFlipbookInPopup')" />
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/zone_kiosque.css')}"/>
        
        <!-- BEGIN head-css-slick-carousel -->
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
        <!-- END head-css-slick-carousel -->
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
        
        <script type="text/javascript">
            $j(function(){
            
                $j('#kiosk-<xsl:value-of select="$uniqueId"/>').slick({
                      regionLabel: "<i18n:text i18n:key="SKIN_SEARCH_KIOSK_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                      infinite: false,
                      autoplay: false,
                      dots: true,
                      pauseOnDotsHover:true,
                      arrows: false,
                      slidesToShow: 5,
                      slidesToScroll: 5,
                      ametysDotsBtnPrefixLabel: "<i18n:text i18n:key="SKIN_SEARCH_KIOSK_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                      responsive: [
                    {
                      breakpoint: 1480,
                      settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4
                      }
                    },
                    {
                      breakpoint: 1024,
                      settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3
                      }
                    },
                    {
                      breakpoint: 700,
                      settings: {
                        slidesToShow: 2,
                        slidesToScroll: 2
                      }
                    },
                    {
                      breakpoint: 500,
                      settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                      }
                    }
                  ]
                })
            });
        </script>
        
        <xsl:if test="$openFlipbookInPopup = 'true'">
            <xsl:call-template name="kiosk-popup-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="kioske" id="kiosk-{$uniqueId}">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
        
        <xsl:call-template name="link-mobile"/> 
        
        <xsl:if test="$openFlipbookInPopup = 'true'">
            <xsl:call-template name="kiosk-popup"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>kioske-item item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn desktop">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus" aria-hidden="true">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-mobile">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag-mobile"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag-mobile">
        <xsl:if test="/search/link/page">
            <a class="btn mobile">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus" aria-hidden="true">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="kiosk-popup">
        <div id="kiosk-overlay-{$uniqueId}" class="ametys-overlay-modal" onclick="closeKioskPopup{$uniqueId}()"></div>
            
        <div id="kiosk-popup-{$uniqueId}" class="ametys-modal ametys-modal-fullscreen" role="dialog" aria-modal="true">
            <button class="ametys-modal-close" onclick="closeKioskPopup{$uniqueId}()" title="skin.{$skin}:SKIN_SEARCH_KIOSK_CLOSE_DIALOG" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
            <div class="ametys-modal-content">
                <iframe allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%; height: 100%" ></iframe>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="kiosk-popup-js">
        <script type="text/javascript">
            const closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/> = (event) => {
                if (event.key === "Escape") {
                  closeKioskPopup<xsl:value-of select="$uniqueId"/>();
                }
            };
            
            var kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = null;
            
            function openKioskPopup<xsl:value-of select="$uniqueId"/>(item)
            {
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = $j(item);
            
                let $dialog = $j('#kiosk-popup-<xsl:value-of select="$uniqueId"/>');
                $dialog.find('iframe').attr('src', $j(item).attr("data-href"));
                $dialog.find('iframe').attr("title", $j(item).attr("title"));
                
                $dialog.attr("aria-label", $j(item).attr("title"));
                $dialog.addClass('active');
                $j('#kiosk-overlay-<xsl:value-of select="$uniqueId"/>').addClass('active');
                
                // Trap focus into modal
                AmetysFront.Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.on('keydown', closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/>);
                
                // Disable scroll on main page
                $j('body').css('overflow', 'hidden');
            }
            
            function closeKioskPopup<xsl:value-of select="$uniqueId"/>()
            {
                let $dialog = $j('#kiosk-popup-<xsl:value-of select="$uniqueId"/>');
                $dialog.removeClass('active');
                $j('#kiosk-overlay-<xsl:value-of select="$uniqueId"/>').removeClass('active');
                
                $dialog.find('iframe').attr('src', '');
                
                AmetysFront.Accessibility.untrapFocus($dialog.get(0));
                $dialog.off('keydown', closeKioskPopupOnEscape<xsl:value-of select="$uniqueId"/>);
                
                // Re-enable scroll on main page
                $j('body').css('overflow', 'inherit');
                
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/>.trigger('focus');
                kioskPopupInvoker<xsl:value-of select="$uniqueId"/> = null;
            }
            
            $j(function(){
            
                // Move popup to body
                $j("#kiosk-popup-<xsl:value-of select="$uniqueId"/>").appendTo(document.body);
                $j("#kiosk-overlay-<xsl:value-of select="$uniqueId"/>").appendTo(document.body);
                
                // Change href by onclick function
                $j('#kiosk-<xsl:value-of select="$uniqueId"/> .kioske-item a').each((index, item) => {
                    $j(item).attr("data-href", $j(item).attr("href"));
                    $j(item).removeAttr("href");
                    $j(item).on('click', function()  {openKioskPopup<xsl:value-of select="$uniqueId"/>(this)});
                })
            });
        </script>
    </xsl:template> 
    
</xsl:stylesheet>